<?php
/**
 * Class that operate on table 'm_check'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MCheckMySqlExtDAO extends MCheckMySqlDAO{

	public function queryByBranchEX($branchId){
		$sql = 'SELECT m_check.*,m_comreceipt.receiptserial,m_comreceiptdetail.productserial,product.productName
					   ,m_comreceiptdetail.granttype, m_comreceiptdetail.id, m_comreceiptdetail.initialcost
					   
				FROM m_check
				
				JOIN m_comreceiptdetail ON  m_comreceiptdetail.ourserial = m_check.ourSerial
				JOIN m_comreceipt ON m_comreceiptdetail.receiptid = m_comreceipt.id
				
				JOIN product ON product.productId = m_comreceiptdetail.productId
				WHERE m_check.branchId = ?
				AND m_comreceipt.status = 0
				AND m_check.del = 0
				AND m_comreceiptdetail.currentstage IN ( 1, 9 )
				';
				
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($branchId);
		//print_r($sqlQuery);
		return $this->getList($sqlQuery);
	}
	
	public function queryByBranchEX2($branchId){
		$sql = 'SELECT m_check.*,m_comreceipt.receiptserial,m_comreceiptdetail.productserial,product.productName
					   ,m_comreceiptdetail.granttype, m_comreceiptdetail.id, m_comreceiptdetail.initialcost
					   ,client.clientname
				FROM m_check
				
				JOIN m_comreceiptdetail ON  m_comreceiptdetail.ourserial = m_check.ourSerial
				JOIN m_comreceipt ON m_comreceiptdetail.receiptid = m_comreceipt.id
				JOIN client ON  m_comreceipt.clientid = client.clientid
				
				JOIN product ON product.productId = m_comreceiptdetail.productId
				WHERE m_check.branchId = ?
				AND m_comreceipt.status = 0
				AND m_check.del = 0
				AND m_comreceiptdetail.currentstage = 6 
				';
					
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($branchId);
		//print_r($sqlQuery);
		return $this->getList($sqlQuery);
	}
	
	public function updatecheck($mCheck){
		$sql = 'UPDATE m_check SET userId = ?, stageFrom = ?, checkDate = ?, branchId = ?, del = ? WHERE ourSerial = ?';
		$sqlQuery = new SqlQuery($sql);
		
		
		$sqlQuery->setNumber($mCheck->userId);
		$sqlQuery->setNumber($mCheck->stageFrom);
		$sqlQuery->set($mCheck->checkDate);
		$sqlQuery->setNumber($mCheck->branchId);
		$sqlQuery->setNumber($mCheck->del);

		$sqlQuery->set($mCheck->ourSerial);
		return $this->executeUpdate($sqlQuery);
	}
	
	public function updatecheckdel($del,$ourSerial){
		$sql = 'UPDATE m_check SET  del = '.$del.' WHERE ourSerial = "'.$ourSerial.'" ';
		$sqlQuery = new SqlQuery($sql);
	
		return $this->executeUpdate($sqlQuery);
	}
	
	public function loadserial($id){
		$sql = 'SELECT * FROM m_check WHERE ourSerial = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($id);
		return $this->getRow($sqlQuery);
	}
	
	
	public function updatecheckdelx($mCheck){
		$sql = 'UPDATE m_check SET  userId = ?, checkDate = ?, branchId = ?, del = ? WHERE checkId = ?';
		$sqlQuery = new SqlQuery($sql);

		$sqlQuery->setNumber($mCheck->userId);
		$sqlQuery->set($mCheck->checkDate);
		$sqlQuery->setNumber($mCheck->branchId);
		$sqlQuery->setNumber($mCheck->del);

		$sqlQuery->setNumber($mCheck->checkId);
		return $this->executeUpdate($sqlQuery);
	}
	
	public function deleteUsingOurSerial($ourSerial){
		$sql = 'DELETE FROM m_check WHERE ourSerial = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($ourSerial);
		return $this->executeUpdate($sqlQuery);
	}
	
	
	
	public function queryByBranchEX2xx($querystring,$branchId){
		$sql = 'SELECT m_check.*,m_comreceipt.receiptserial,m_comreceiptdetail.productserial,product.productName
					   ,m_comreceiptdetail.granttype, m_comreceiptdetail.id, m_comreceiptdetail.initialcost
					   ,client.clientname
				FROM m_check
				
				JOIN m_comreceiptdetail ON  m_comreceiptdetail.ourserial = m_check.ourSerial
				JOIN m_comreceipt ON m_comreceiptdetail.receiptid = m_comreceipt.id
				JOIN client ON  m_comreceipt.clientid = client.clientid
				
				JOIN product ON product.productId = m_comreceiptdetail.productId
				'.$querystring.'
				and m_check.branchId = ?
				AND m_comreceipt.status = 0
				AND m_check.del = 0
				AND m_comreceiptdetail.currentstage = 6 
				';
		
		//print_r("<br>".$sql);		
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($branchId);
		//print_r($sqlQuery);
		return $this->getList($sqlQuery);
	}
}
?>