<?php

/**
 * Class that operate on table 'vatpayment'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-07-26 14:55
 */
class VatpaymentMySqlDAO implements VatpaymentDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return VatpaymentMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM vatpayment WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM vatpayment';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM vatpayment ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param vatpayment primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM vatpayment WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param VatpaymentMySql vatpayment
     */
    public function insert($vatpayment) {
        $sql = 'INSERT INTO vatpayment (amount, saveid, comment, userid, sysdate, conditions) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($vatpayment->amount);
        $sqlQuery->setNumber($vatpayment->saveid);
        $sqlQuery->setString2($vatpayment->comment);
        $sqlQuery->setNumber($vatpayment->userid);
        $sqlQuery->set($vatpayment->sysdate);
        $sqlQuery->setNumber($vatpayment->conditions);

        $id = $this->executeInsert($sqlQuery);
        $vatpayment->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param VatpaymentMySql vatpayment
     */
    public function update($vatpayment) {
        $sql = 'UPDATE vatpayment SET amount = ?, saveid = ?, comment = ?, userid = ?, sysdate = ?, conditions = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($vatpayment->amount);
        $sqlQuery->setNumber($vatpayment->saveid);
        $sqlQuery->setString2($vatpayment->comment);
        $sqlQuery->setNumber($vatpayment->userid);
        $sqlQuery->set($vatpayment->sysdate);
        $sqlQuery->setNumber($vatpayment->conditions);

        $sqlQuery->setNumber($vatpayment->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM vatpayment';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByAmount($value) {
        $sql = 'SELECT * FROM vatpayment WHERE amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM vatpayment WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM vatpayment WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM vatpayment WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM vatpayment WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM vatpayment WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByAmount($value) {
        $sql = 'DELETE FROM vatpayment WHERE amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM vatpayment WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM vatpayment WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM vatpayment WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM vatpayment WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM vatpayment WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return VatpaymentMySql
     */
    protected function readRow($row) {
        $vatpayment = new Vatpayment();

        $vatpayment->id = $row['id'];
        $vatpayment->amount = $row['amount'];
        $vatpayment->saveid = $row['saveid'];
        $vatpayment->comment = $row['comment'];
        $vatpayment->userid = $row['userid'];
        $vatpayment->sysdate = $row['sysdate'];
        $vatpayment->conditions = $row['conditions'];
        //
        $vatpayment->username = $row['username'];
        $vatpayment->savename = $row['savename'];

        return $vatpayment;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return VatpaymentMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>