<?php

/**
 * Class that operate on table 'suppay'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-20 10:40
 */
class SuppayMySqlDAO implements SuppayDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SuppayMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM suppay WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM suppay';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM suppay ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param suppay primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM suppay WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SuppayMySql suppay
     */
    public function insert($suppay) {
        $sql = 'INSERT INTO suppay (idsupdeptchange, paytype,accountid,del,bankid,checkno,beneficiaryname,chckdate,chckimage,senderbank,details) VALUES (?, ?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($suppay->idsupdeptchange);
        $sqlQuery->setNumber($suppay->paytype);
        $sqlQuery->setNumber($suppay->accountid);
        $sqlQuery->setNumber($suppay->del);
        $sqlQuery->setNumber($suppay->bankid);
        $sqlQuery->setNumber($suppay->checkno);
        $sqlQuery->set($suppay->beneficiaryname);
        $sqlQuery->set($suppay->chckdate);
        $sqlQuery->set($suppay->chckimage);
        $sqlQuery->set($suppay->senderbank);
        $sqlQuery->set($suppay->details);


        $id = $this->executeInsert($sqlQuery);
        $suppay->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SuppayMySql suppay
     */
    public function update($suppay) {
        $sql = 'UPDATE suppay SET idsupdeptchange = ?, paytype = ? ,accountid = ?, del=?,bankid=? , checkno = ? , beneficiaryname = ? , chckdate = ?,chckimage=? , senderbank=? ,details=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($suppay->idsupdeptchange);
        $sqlQuery->setNumber($suppay->paytype);
        $sqlQuery->setNumber($suppay->accountid);
        $sqlQuery->setNumber($suppay->del);
        $sqlQuery->setNumber($suppay->bankid);
        $sqlQuery->setNumber($suppay->checkno);
        $sqlQuery->set($suppay->beneficiaryname);
        $sqlQuery->set($suppay->chckdate);
        $sqlQuery->set($suppay->chckimage);
        $sqlQuery->set($suppay->senderbank);
        $sqlQuery->set($suppay->details);



        $sqlQuery->setNumber($suppay->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM suppay';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByIdsupdeptchange($value) {
        $sql = 'SELECT * FROM suppay WHERE idsupdeptchange = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaytype($value) {
        $sql = 'SELECT * FROM suppay WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByIdsupdeptchange($value) {
        $sql = 'DELETE FROM suppay WHERE idsupdeptchange = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaytype($value) {
        $sql = 'DELETE FROM suppay WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SuppayMySql
     */
    protected function readRow($row) {
        $suppay = new Suppay();

        $suppay->id = isset($row['id']) ? $row['id'] : '';
        $suppay->idsupdeptchange = isset($row['idsupdeptchange']) ? $row['idsupdeptchange'] : '';
        $suppay->paytype = isset($row['paytype']) ? $row['paytype'] : '';
        $suppay->accountid = isset($row['accountid']) ? $row['accountid'] : '';
        $suppay->del = isset($row['del']) ? $row['del'] : '';
        $suppay->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $suppay->checkno = isset($row['checkno']) ? $row['checkno'] : '';
        $suppay->beneficiaryname = isset($row['beneficiaryname']) ? $row['beneficiaryname'] : '';
        $suppay->chckdate = isset($row['chckdate']) ? $row['chckdate'] : '';
        $suppay->chckimage = isset($row['chckimage']) ? $row['chckimage'] : '';
        $suppay->senderbank = isset($row['senderbank']) ? $row['senderbank'] : '';
        $suppay->details = isset($row['details']) ? $row['details'] : '';


        return $suppay;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SuppayMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>