<?php

/**
 * Class that operate on table 'storereport'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class StorereportMySqlDAO implements StorereportDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return StorereportMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM storereport WHERE storereportid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM storereport';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM storereport ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param storereport primary key
     */
    public function delete($storereportid) {
        $sql = 'DELETE FROM storereport WHERE storereportid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($storereportid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param StorereportMySql storereport
     */
    public function insert($storereport) {
        $sql = 'INSERT INTO storereport (productid, storeid, productquantity, storereporttype, storereportmodelid, processname, tablename, productbefore, productafter, userid, storereportdate,sizeid,colorid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($storereport->productid);
        $sqlQuery->setNumber($storereport->storeid);
        $sqlQuery->setNumber($storereport->productquantity);
        $sqlQuery->setNumber($storereport->storereporttype);
        $sqlQuery->setNumber($storereport->storereportmodelid);
        $sqlQuery->set($storereport->processname);
        $sqlQuery->set($storereport->tablename);
        $sqlQuery->setNumber($storereport->productbefore);
        $sqlQuery->setNumber($storereport->productafter);
        $sqlQuery->setNumber($storereport->userid);
        $sqlQuery->set($storereport->storereportdate);
        $sqlQuery->setNumber((int) $storereport->sizeid);
        $sqlQuery->setNumber((int) $storereport->colorid);

        $id = $this->executeInsert($sqlQuery);
        $storereport->storereportid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param StorereportMySql storereport
     */
    public function update($storereport) {
        $sql = 'UPDATE storereport SET productid = ?, storeid = ?, productquantity = ?, storereporttype = ?, storereportmodelid = ?, processname = ?, tablename = ?, productbefore = ?, productafter = ?, userid = ?, storereportdate = ?,sizeid = ?,colorid = ? WHERE storereportid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($storereport->productid);
        $sqlQuery->setNumber($storereport->storeid);
        $sqlQuery->setNumber($storereport->productquantity);
        $sqlQuery->setNumber($storereport->storereporttype);
        $sqlQuery->setNumber($storereport->storereportmodelid);
        $sqlQuery->set($storereport->processname);
        $sqlQuery->set($storereport->tablename);
        $sqlQuery->setNumber($storereport->productbefore);
        $sqlQuery->setNumber($storereport->productafter);
        $sqlQuery->setNumber($storereport->userid);
        $sqlQuery->set($storereport->storereportdate);
        $sqlQuery->setNumber((int) $storereport->sizeid);
        $sqlQuery->setNumber((int) $storereport->colorid);

        $sqlQuery->setNumber($storereport->storereportid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM storereport';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM storereport WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM storereport WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductquantity($value) {
        $sql = 'SELECT * FROM storereport WHERE productquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorereporttype($value) {
        $sql = 'SELECT * FROM storereport WHERE storereporttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorereportmodelid($value) {
        $sql = 'SELECT * FROM storereport WHERE storereportmodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM storereport WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM storereport WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductbefore($value) {
        $sql = 'SELECT * FROM storereport WHERE productbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductafter($value) {
        $sql = 'SELECT * FROM storereport WHERE productafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM storereport WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorereportdate($value) {
        $sql = 'SELECT * FROM storereport WHERE storereportdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM storereport WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM storereport WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductquantity($value) {
        $sql = 'DELETE FROM storereport WHERE productquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorereporttype($value) {
        $sql = 'DELETE FROM storereport WHERE storereporttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorereportmodelid($value) {
        $sql = 'DELETE FROM storereport WHERE storereportmodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM storereport WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM storereport WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductbefore($value) {
        $sql = 'DELETE FROM storereport WHERE productbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductafter($value) {
        $sql = 'DELETE FROM storereport WHERE productafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM storereport WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorereportdate($value) {
        $sql = 'DELETE FROM storereport WHERE storereportdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return StorereportMySql
     */
    protected function readRow($row) {
        $storereport = new Storereport();

        $storereport->storereportid = isset($row['storereportid']) ? $row['storereportid'] : '';
        $storereport->productid = isset($row['productid']) ? $row['productid'] : '';
        $storereport->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $storereport->productquantity = isset($row['productquantity']) ? (float) $row['productquantity'] : '';
        $storereport->storereporttype = isset($row['storereporttype']) ? $row['storereporttype'] : '';
        $storereport->storereportmodelid = isset($row['storereportmodelid']) ? $row['storereportmodelid'] : '';
        $storereport->processname = isset($row['processname']) ? $row['processname'] : '';
        $storereport->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $storereport->productbefore = isset($row['productbefore']) ? (float) $row['productbefore'] : '';
        $storereport->productafter = isset($row['productafter']) ? (float) $row['productafter'] : '';
        $storereport->userid = isset($row['userid']) ? $row['userid'] : '';
        $storereport->storereportdate = isset($row['storereportdate']) ? $row['storereportdate'] : '';
        $storereport->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $storereport->colorid = isset($row['colorid']) ? $row['colorid'] : '';


        //required
        $storereport->productName = isset($row['productName']) ? $row['productName'] : '';
        $storereport->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $storereport->productSellUnitPrice = isset($row['productSellUnitPrice']) ? $row['productSellUnitPrice'] : '';
        $storereport->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $storereport->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $storereport->finalstring = isset($row['finalstring']) ? $row['finalstring'] : '';
        $storereport->productquantitya = isset($row['productquantitya']) ? $row['productquantitya'] : '';
        $storereport->productquantityb = isset($row['productquantityb']) ? $row['productquantityb'] : '';
        $storereport->unittype = isset($row['unittype']) ? $row['unittype'] : '';
        $storereport->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $storereport->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $storereport->sizecolorstoredetailid = isset($row['sizecolorstoredetailid']) ? $row['sizecolorstoredetailid'] : '';
        $storereport->pricebuy = isset($row['pricebuy']) ? $row['pricebuy'] : '';





        return $storereport;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return StorereportMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>