<?php

/**
 * Class that operate on table 'soldserialproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-12-11 13:02
 */
class SoldserialproductMySqlDAO implements SoldserialproductDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SoldserialproductMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM soldserialproduct WHERE soldserialproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM soldserialproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM soldserialproduct ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param soldserialproduct primary key
     */
    public function delete($soldserialproductid) {
        $sql = 'DELETE FROM soldserialproduct WHERE soldserialproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($soldserialproductid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SoldserialproductMySql soldserialproduct
     */
    public function insert($soldserialproduct) {
        $sql = 'INSERT INTO soldserialproduct (productserailid, sellbillid, sellbilltype, quantity,del,clientid) VALUES (?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($soldserialproduct->productserailid);
        $sqlQuery->setNumber($soldserialproduct->sellbillid);
        $sqlQuery->setNumber($soldserialproduct->sellbilltype);
        $sqlQuery->setNumber($soldserialproduct->quantity);
        $sqlQuery->setNumber($soldserialproduct->del);
        $sqlQuery->setNumber((int)$soldserialproduct->clientid);

        $id = $this->executeInsert($sqlQuery);
        $soldserialproduct->soldserialproductid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SoldserialproductMySql soldserialproduct
     */
    public function update($soldserialproduct) {
        $sql = 'UPDATE soldserialproduct SET productserailid = ?, sellbillid = ?, sellbilltype = ?, quantity = ?,clientid=? WHERE soldserialproductid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($soldserialproduct->productserailid);
        $sqlQuery->setNumber($soldserialproduct->sellbillid);
        $sqlQuery->setNumber($soldserialproduct->sellbilltype);
        $sqlQuery->setNumber($soldserialproduct->quantity);
        $sqlQuery->setNumber((int)$soldserialproduct->clientid);

        $sqlQuery->setNumber($soldserialproduct->soldserialproductid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM soldserialproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductserailid($value) {
        $sql = 'SELECT * FROM soldserialproduct WHERE productserailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM soldserialproduct WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltype($value) {
        $sql = 'SELECT * FROM soldserialproduct WHERE sellbilltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM soldserialproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductserailid($value) {
        $sql = 'DELETE FROM soldserialproduct WHERE productserailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM soldserialproduct WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltype($value) {
        $sql = 'DELETE FROM soldserialproduct WHERE sellbilltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM soldserialproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SoldserialproductMySql
     */
    protected function readRow($row) {
        $soldserialproduct = new Soldserialproduct();

        $soldserialproduct->soldserialproductid = isset($row['soldserialproductid']) ? $row['soldserialproductid'] : '';
        $soldserialproduct->productserailid = isset($row['productserailid']) ? $row['productserailid'] : '';
        $soldserialproduct->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $soldserialproduct->sellbilltype = isset($row['sellbilltype']) ? $row['sellbilltype'] : '';
        $soldserialproduct->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $soldserialproduct->del = isset($row['del']) ? $row['del'] : '';
        $soldserialproduct->clientid = isset($row['clientid']) ? $row['clientid'] : '';


        //req
        $soldserialproduct->productName = isset($row['productName']) ? $row['productName'] : '';
        $soldserialproduct->productSellUnitPrice = isset($row['productSellUnitPrice']) ? $row['productSellUnitPrice'] : '';
        $soldserialproduct->startdate = isset($row['startdate']) ? $row['startdate'] : '';
        $soldserialproduct->enddate = isset($row['enddate']) ? $row['enddate'] : '';
        
        $soldserialproduct->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $soldserialproduct->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $soldserialproduct->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $soldserialproduct->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $soldserialproduct->serialnumber = isset($row['serialnumber']) ? $row['serialnumber'] : '';
        $soldserialproduct->don = isset($row['don']) ? $row['don'] : '';


        return $soldserialproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SoldserialproductMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>