<?php
/**
 * Class that operate on table 'sellbillstatus'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-11-29 19:00
 */
class SellbillstatusMySqlDAO implements SellbillstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return SellbillstatusMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM sellbillstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM sellbillstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM sellbillstatus ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param sellbillstatu primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM sellbillstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param SellbillstatusMySql sellbillstatu
 	 */
	public function insert($sellbillstatu){
		$sql = 'INSERT INTO sellbillstatus (sellbillid, status, userid, sysdate) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($sellbillstatu->sellbillid);
		$sqlQuery->set($sellbillstatu->status);
		$sqlQuery->setNumber($sellbillstatu->userid);
		$sqlQuery->set($sellbillstatu->sysdate);

		$id = $this->executeInsert($sqlQuery);	
		$sellbillstatu->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param SellbillstatusMySql sellbillstatu
 	 */
	public function update($sellbillstatu){
		$sql = 'UPDATE sellbillstatus SET sellbillid = ?, status = ?, userid = ?, sysdate = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($sellbillstatu->sellbillid);
		$sqlQuery->set($sellbillstatu->status);
		$sqlQuery->setNumber($sellbillstatu->userid);
		$sqlQuery->set($sellbillstatu->sysdate);

		$sqlQuery->setNumber($sellbillstatu->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM sellbillstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySellbillid($value){
		$sql = 'SELECT * FROM sellbillstatus WHERE sellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM sellbillstatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM sellbillstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM sellbillstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySellbillid($value){
		$sql = 'DELETE FROM sellbillstatus WHERE sellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM sellbillstatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM sellbillstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM sellbillstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return SellbillstatusMySql 
	 */
	protected function readRow($row){
		$sellbillstatu = new Sellbillstatu();
		
		$sellbillstatu->id = $row['id'];
		$sellbillstatu->sellbillid = $row['sellbillid'];
		$sellbillstatu->status = $row['status'];
		$sellbillstatu->userid = $row['userid'];
		$sellbillstatu->sysdate = $row['sysdate'];

		return $sellbillstatu;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return SellbillstatusMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>