<?php

/**
 * Class that operate on table 'sellbilldetailoffer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-08-24 15:23
 */
class SellbilldetailofferMySqlDAO implements SellbilldetailofferDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbilldetailofferMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbilldetailoffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbilldetailoffer ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbilldetailoffer primary key
     */
    public function delete($sellbilldetailid) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbilldetailofferMySql sellbilldetailoffer
     */
    public function insert($sellbilldetailoffer) {
        $sql = 'INSERT INTO sellbilldetailoffer (buyprice, parcode, sellbillid, sellbilldetailcatid, sellbilldetailproductid, sellbilldetailquantity, sellbilldetailprice, sellbilldetailtotalprice, discountvalue, note, pricetype, sellbilldetaildate, productunitid, buydiscount, buydiscounttype, storeid, discounttype, localdonw, lastbuyprice, meanbuyprice, lastbuyprice_withDiscount, meanbuyprice_withDiscount, scunitqty, otherdetailquantity, sizeid, colorid, onlineOrderId, pricetypepro) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilldetailoffer->buyprice);
        $sqlQuery->set($sellbilldetailoffer->parcode);
        $sqlQuery->setNumber($sellbilldetailoffer->sellbillid);
        $sqlQuery->setNumber($sellbilldetailoffer->sellbilldetailcatid);
        $sqlQuery->setNumber($sellbilldetailoffer->sellbilldetailproductid);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetailquantity);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetailprice);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetailtotalprice);
        $sqlQuery->set($sellbilldetailoffer->discountvalue);
        $sqlQuery->set($sellbilldetailoffer->note);
        $sqlQuery->setNumber($sellbilldetailoffer->pricetype);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetaildate);
        $sqlQuery->setNumber($sellbilldetailoffer->productunitid);
        $sqlQuery->set($sellbilldetailoffer->buydiscount);
        $sqlQuery->setNumber($sellbilldetailoffer->buydiscounttype);
        $sqlQuery->setNumber($sellbilldetailoffer->storeid);
        $sqlQuery->set($sellbilldetailoffer->discounttype);
        $sqlQuery->setNumber($sellbilldetailoffer->localdonw);
        $sqlQuery->set($sellbilldetailoffer->lastbuyprice);
        $sqlQuery->set($sellbilldetailoffer->meanbuyprice);
        $sqlQuery->set($sellbilldetailoffer->lastbuypriceWithDiscount);
        $sqlQuery->set($sellbilldetailoffer->meanbuypriceWithDiscount);
        $sqlQuery->setNumber($sellbilldetailoffer->scunitqty);
        $sqlQuery->setNumber($sellbilldetailoffer->otherdetailquantity);
        $sqlQuery->setNumber($sellbilldetailoffer->sizeid);
        $sqlQuery->setNumber($sellbilldetailoffer->colorid);
        $sqlQuery->setNumber($sellbilldetailoffer->onlineOrderId);
        $sqlQuery->setNumber($sellbilldetailoffer->pricetypepro);

        $id = $this->executeInsert($sqlQuery);
        $sellbilldetailoffer->sellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbilldetailofferMySql sellbilldetailoffer
     */
    public function update($sellbilldetailoffer) {
        $sql = 'UPDATE sellbilldetailoffer SET buyprice = ?, parcode = ?, sellbillid = ?, sellbilldetailcatid = ?, sellbilldetailproductid = ?, sellbilldetailquantity = ?, sellbilldetailprice = ?, sellbilldetailtotalprice = ?, discountvalue = ?, note = ?, pricetype = ?, sellbilldetaildate = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ?, storeid = ?, discounttype = ?, localdonw = ?, lastbuyprice = ?, meanbuyprice = ?, lastbuyprice_withDiscount = ?, meanbuyprice_withDiscount = ?, scunitqty = ?, otherdetailquantity = ?, sizeid = ?, colorid = ?, onlineOrderId = ?, pricetypepro = ? WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilldetailoffer->buyprice);
        $sqlQuery->set($sellbilldetailoffer->parcode);
        $sqlQuery->setNumber($sellbilldetailoffer->sellbillid);
        $sqlQuery->setNumber($sellbilldetailoffer->sellbilldetailcatid);
        $sqlQuery->setNumber($sellbilldetailoffer->sellbilldetailproductid);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetailquantity);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetailprice);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetailtotalprice);
        $sqlQuery->set($sellbilldetailoffer->discountvalue);
        $sqlQuery->set($sellbilldetailoffer->note);
        $sqlQuery->setNumber($sellbilldetailoffer->pricetype);
        $sqlQuery->set($sellbilldetailoffer->sellbilldetaildate);
        $sqlQuery->setNumber($sellbilldetailoffer->productunitid);
        $sqlQuery->set($sellbilldetailoffer->buydiscount);
        $sqlQuery->setNumber($sellbilldetailoffer->buydiscounttype);
        $sqlQuery->setNumber($sellbilldetailoffer->storeid);
        $sqlQuery->set($sellbilldetailoffer->discounttype);
        $sqlQuery->setNumber($sellbilldetailoffer->localdonw);
        $sqlQuery->set($sellbilldetailoffer->lastbuyprice);
        $sqlQuery->set($sellbilldetailoffer->meanbuyprice);
        $sqlQuery->set($sellbilldetailoffer->lastbuypriceWithDiscount);
        $sqlQuery->set($sellbilldetailoffer->meanbuypriceWithDiscount);
        $sqlQuery->setNumber($sellbilldetailoffer->scunitqty);
        $sqlQuery->setNumber($sellbilldetailoffer->otherdetailquantity);
        $sqlQuery->setNumber($sellbilldetailoffer->sizeid);
        $sqlQuery->setNumber($sellbilldetailoffer->colorid);
        $sqlQuery->setNumber($sellbilldetailoffer->onlineOrderId);
        $sqlQuery->setNumber($sellbilldetailoffer->pricetypepro);

        $sqlQuery->setNumber($sellbilldetailoffer->sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbilldetailoffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailcatid($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailproductid($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailquantity($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailprice($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetaildate($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductunitid($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscount($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscounttype($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscounttype($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLocaldonw($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE localdonw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastbuyprice($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE lastbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeanbuyprice($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE meanbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastbuypriceWithDiscount($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE lastbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeanbuypriceWithDiscount($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE meanbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByScunitqty($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE scunitqty = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOtherdetailquantity($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE otherdetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOnlineOrderId($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE onlineOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetypepro($value) {
        $sql = 'SELECT * FROM sellbilldetailoffer WHERE pricetypepro = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailcatid($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailproductid($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailquantity($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailprice($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetaildate($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductunitid($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscount($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscounttype($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscounttype($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLocaldonw($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE localdonw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastbuyprice($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE lastbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeanbuyprice($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE meanbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastbuypriceWithDiscount($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE lastbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeanbuypriceWithDiscount($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE meanbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByScunitqty($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE scunitqty = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOtherdetailquantity($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE otherdetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOnlineOrderId($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE onlineOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetypepro($value) {
        $sql = 'DELETE FROM sellbilldetailoffer WHERE pricetypepro = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbilldetailofferMySql
     */
    protected function readRow($row) {
        $sellbilldetailoffer = new Sellbilldetailoffer();

        $sellbilldetailoffer->buyprice = $row['buyprice'];
        $sellbilldetailoffer->parcode = $row['parcode'];
        $sellbilldetailoffer->sellbilldetailid = $row['sellbilldetailid'];
        $sellbilldetailoffer->sellbillid = $row['sellbillid'];
        $sellbilldetailoffer->sellbilldetailcatid = $row['sellbilldetailcatid'];
        $sellbilldetailoffer->sellbilldetailproductid = $row['sellbilldetailproductid'];
        $sellbilldetailoffer->sellbilldetailquantity = $row['sellbilldetailquantity'];
        $sellbilldetailoffer->sellbilldetailprice = $row['sellbilldetailprice'];
        $sellbilldetailoffer->sellbilldetailtotalprice = $row['sellbilldetailtotalprice'];
        $sellbilldetailoffer->discountvalue = $row['discountvalue'];
        $sellbilldetailoffer->note = $row['note'];
        $sellbilldetailoffer->pricetype = $row['pricetype'];
        $sellbilldetailoffer->sellbilldetaildate = $row['sellbilldetaildate'];
        $sellbilldetailoffer->productunitid = $row['productunitid'];
        $sellbilldetailoffer->buydiscount = $row['buydiscount'];
        $sellbilldetailoffer->buydiscounttype = $row['buydiscounttype'];
        $sellbilldetailoffer->storeid = $row['storeid'];
        $sellbilldetailoffer->discounttype = $row['discounttype'];
        $sellbilldetailoffer->localdonw = $row['localdonw'];
        $sellbilldetailoffer->lastbuyprice = $row['lastbuyprice'];
        $sellbilldetailoffer->meanbuyprice = $row['meanbuyprice'];
        $sellbilldetailoffer->lastbuypriceWithDiscount = $row['lastbuyprice_withDiscount'];
        $sellbilldetailoffer->meanbuypriceWithDiscount = $row['meanbuyprice_withDiscount'];
        $sellbilldetailoffer->scunitqty = $row['scunitqty'];
        $sellbilldetailoffer->otherdetailquantity = $row['otherdetailquantity'];
        $sellbilldetailoffer->sizeid = $row['sizeid'];
        $sellbilldetailoffer->colorid = $row['colorid'];
        $sellbilldetailoffer->onlineOrderId = $row['onlineOrderId'];
        $sellbilldetailoffer->pricetypepro = $row['pricetypepro'];
        //
        $sellbilldetailoffer->productName = $row['productName'];
        $sellbilldetailoffer->storeName = $row['storeName'];
        $sellbilldetailoffer->unitName = $row['unitName'];
        $sellbilldetailoffer->productCatName = $row['productCatName'];
        $sellbilldetailoffer->sizeName = $row['sizeName'];
        $sellbilldetailoffer->colorName = $row['colorName'];
        return $sellbilldetailoffer;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbilldetailofferMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>