<?php
/**
 * Class that operate on table 'returnbuybillcurr'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-12-27 23:59
 */
class ReturnbuybillcurrMySqlDAO implements ReturnbuybillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return ReturnbuybillcurrMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM returnbuybillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM returnbuybillcurr ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param returnbuybillcurr primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM returnbuybillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ReturnbuybillcurrMySql returnbuybillcurr
 	 */
	public function insert($returnbuybillcurr){
		$sql = 'INSERT INTO returnbuybillcurr (buybillid, conversionFactor, returnbuybilldiscountC, returnbuybilltotalbillC, returnbuybillaftertotalbillC, returnbuybilltotalpayedC, returnbuybillfinalbillC, returnbuybilldirectpaymentC, payedtaxC, saveConversionFactor) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($returnbuybillcurr->buybillid);
		$sqlQuery->set($returnbuybillcurr->conversionFactor);
		$sqlQuery->set($returnbuybillcurr->returnbuybilldiscountC);
		$sqlQuery->set($returnbuybillcurr->returnbuybilltotalbillC);
		$sqlQuery->set($returnbuybillcurr->returnbuybillaftertotalbillC);
		$sqlQuery->set($returnbuybillcurr->returnbuybilltotalpayedC);
		$sqlQuery->set($returnbuybillcurr->returnbuybillfinalbillC);
		$sqlQuery->setNumber($returnbuybillcurr->returnbuybilldirectpaymentC);
		$sqlQuery->set($returnbuybillcurr->payedtaxC);
		$sqlQuery->set($returnbuybillcurr->saveConversionFactor);

		$id = $this->executeInsert($sqlQuery);	
		$returnbuybillcurr->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param ReturnbuybillcurrMySql returnbuybillcurr
 	 */
	public function update($returnbuybillcurr){
		$sql = 'UPDATE returnbuybillcurr SET buybillid = ?, conversionFactor = ?, returnbuybilldiscountC = ?, returnbuybilltotalbillC = ?, returnbuybillaftertotalbillC = ?, returnbuybilltotalpayedC = ?, returnbuybillfinalbillC = ?, returnbuybilldirectpaymentC = ?, payedtaxC = ?, saveConversionFactor = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($returnbuybillcurr->buybillid);
		$sqlQuery->set($returnbuybillcurr->conversionFactor);
		$sqlQuery->set($returnbuybillcurr->returnbuybilldiscountC);
		$sqlQuery->set($returnbuybillcurr->returnbuybilltotalbillC);
		$sqlQuery->set($returnbuybillcurr->returnbuybillaftertotalbillC);
		$sqlQuery->set($returnbuybillcurr->returnbuybilltotalpayedC);
		$sqlQuery->set($returnbuybillcurr->returnbuybillfinalbillC);
		$sqlQuery->setNumber($returnbuybillcurr->returnbuybilldirectpaymentC);
		$sqlQuery->set($returnbuybillcurr->payedtaxC);
		$sqlQuery->set($returnbuybillcurr->saveConversionFactor);

		$sqlQuery->setNumber($returnbuybillcurr->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM returnbuybillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByBuybillid($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE buybillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactor($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnbuybilldiscountC($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE returnbuybilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnbuybilltotalbillC($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE returnbuybilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnbuybillaftertotalbillC($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE returnbuybillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnbuybilltotalpayedC($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE returnbuybilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnbuybillfinalbillC($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE returnbuybillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnbuybilldirectpaymentC($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE returnbuybilldirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPayedtaxC($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE payedtaxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveConversionFactor($value){
		$sql = 'SELECT * FROM returnbuybillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByBuybillid($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE buybillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactor($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnbuybilldiscountC($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE returnbuybilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnbuybilltotalbillC($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE returnbuybilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnbuybillaftertotalbillC($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE returnbuybillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnbuybilltotalpayedC($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE returnbuybilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnbuybillfinalbillC($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE returnbuybillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnbuybilldirectpaymentC($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE returnbuybilldirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPayedtaxC($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE payedtaxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveConversionFactor($value){
		$sql = 'DELETE FROM returnbuybillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return ReturnbuybillcurrMySql 
	 */
	protected function readRow($row){
		$returnbuybillcurr = new Returnbuybillcurr();
		
		$returnbuybillcurr->id = $row['id'];
		$returnbuybillcurr->buybillid = $row['buybillid'];
		$returnbuybillcurr->conversionFactor = $row['conversionFactor'];
		$returnbuybillcurr->returnbuybilldiscountC = $row['returnbuybilldiscountC'];
		$returnbuybillcurr->returnbuybilltotalbillC = $row['returnbuybilltotalbillC'];
		$returnbuybillcurr->returnbuybillaftertotalbillC = $row['returnbuybillaftertotalbillC'];
		$returnbuybillcurr->returnbuybilltotalpayedC = $row['returnbuybilltotalpayedC'];
		$returnbuybillcurr->returnbuybillfinalbillC = $row['returnbuybillfinalbillC'];
		$returnbuybillcurr->returnbuybilldirectpaymentC = $row['returnbuybilldirectpaymentC'];
		$returnbuybillcurr->payedtaxC = $row['payedtaxC'];
		$returnbuybillcurr->saveConversionFactor = $row['saveConversionFactor'];

		return $returnbuybillcurr;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return ReturnbuybillcurrMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>