<?php

/**
 * Class that operate on table 'returnbuybill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ReturnbuybillMySqlDAO implements ReturnbuybillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ReturnbuybillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM returnbuybill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM returnbuybill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param returnbuybill primary key
     */
    public function delete($returnbuybillid) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($returnbuybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ReturnbuybillMySql returnbuybill
     */
    public function insert($returnbuybill) {
        $sql = 'INSERT INTO returnbuybill (returnbuybillSerial, returnbuybilldate, returnbuybillsupplierid, returnbuybilltotaldeptbefor, returnbuybilltotaldeptafter, returnbuybilldiscount, returnbuybilldiscountrype, returnbuybilltotalbill, returnbuybillaftertotalbill, returnbuybilltotalpayed, returnbuybillfinalbill, returnbuybillstoreid, returnbuybillsysdate,comment, userid, conditions, returnbuybillclientname, returnbuybillsaveid, billnameid, returnbuybilldirectpayment,payedtax,costcenterid,delbyuserid,currencyId,taxOfDiscountPer,taxOfDiscountVal,client) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnbuybill->returnbuybillSerial);
        $sqlQuery->set($returnbuybill->returnbuybilldate);
        $sqlQuery->setNumber($returnbuybill->returnbuybillsupplierid);
        $sqlQuery->set($returnbuybill->returnbuybilltotaldeptbefor);
        $sqlQuery->set($returnbuybill->returnbuybilltotaldeptafter);
        $sqlQuery->set($returnbuybill->returnbuybilldiscount);
        $sqlQuery->setNumber($returnbuybill->returnbuybilldiscountrype);
        $sqlQuery->set($returnbuybill->returnbuybilltotalbill);
        $sqlQuery->set($returnbuybill->returnbuybillaftertotalbill);
        $sqlQuery->set($returnbuybill->returnbuybilltotalpayed);
        $sqlQuery->set($returnbuybill->returnbuybillfinalbill);
        $sqlQuery->setNumber($returnbuybill->returnbuybillstoreid);
        $sqlQuery->set($returnbuybill->returnbuybillsysdate);
        $sqlQuery->set($returnbuybill->comment);
        $sqlQuery->setNumber($returnbuybill->userid);
        $sqlQuery->setNumber($returnbuybill->conditions);
        $sqlQuery->set($returnbuybill->returnbuybillclientname);
        $sqlQuery->setNumber($returnbuybill->returnbuybillsaveid);
        $sqlQuery->setNumber($returnbuybill->billnameid);
        $sqlQuery->setNumber($returnbuybill->returnbuybilldirectpayment);
        $sqlQuery->set($returnbuybill->payedtax);
        $sqlQuery->set($returnbuybill->costcenterid);
        $sqlQuery->setNumber((int) $returnbuybill->delbyuserid);
        $sqlQuery->setNumber((int) $returnbuybill->currencyId);
        $sqlQuery->setNumber((float) $returnbuybill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $returnbuybill->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $returnbuybill->client);




        $id = $this->executeInsert($sqlQuery);
        $returnbuybill->returnbuybillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ReturnbuybillMySql returnbuybill
     */
    public function update($returnbuybill) {
        $sql = 'UPDATE returnbuybill SET returnbuybillSerial = ?, returnbuybilldate = ?, returnbuybillsupplierid = ?, returnbuybilltotaldeptbefor = ?, returnbuybilltotaldeptafter = ?, returnbuybilldiscount = ?, returnbuybilldiscountrype = ?, returnbuybilltotalbill = ?, returnbuybillaftertotalbill = ?, returnbuybilltotalpayed = ?, returnbuybillfinalbill = ?, returnbuybillstoreid = ?, returnbuybillsysdate = ?,comment = ?, userid = ?, conditions = ?, returnbuybillclientname = ?, returnbuybillsaveid = ?, billnameid = ?, returnbuybilldirectpayment = ?,dailyentryid = ?,delbyuserid = ?,currencyId=?, taxOfDiscountPer=?, taxOfDiscountVal=? WHERE returnbuybillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnbuybill->returnbuybillSerial);
        $sqlQuery->set($returnbuybill->returnbuybilldate);
        $sqlQuery->setNumber($returnbuybill->returnbuybillsupplierid);
        $sqlQuery->set($returnbuybill->returnbuybilltotaldeptbefor);
        $sqlQuery->set($returnbuybill->returnbuybilltotaldeptafter);
        $sqlQuery->set($returnbuybill->returnbuybilldiscount);
        $sqlQuery->setNumber($returnbuybill->returnbuybilldiscountrype);
        $sqlQuery->set($returnbuybill->returnbuybilltotalbill);
        $sqlQuery->set($returnbuybill->returnbuybillaftertotalbill);
        $sqlQuery->set($returnbuybill->returnbuybilltotalpayed);
        $sqlQuery->set($returnbuybill->returnbuybillfinalbill);
        $sqlQuery->setNumber($returnbuybill->returnbuybillstoreid);
        $sqlQuery->set($returnbuybill->returnbuybillsysdate);
        $sqlQuery->set($returnbuybill->comment);
        $sqlQuery->setNumber($returnbuybill->userid);
        $sqlQuery->setNumber($returnbuybill->conditions);
        $sqlQuery->set($returnbuybill->returnbuybillclientname);
        $sqlQuery->setNumber($returnbuybill->returnbuybillsaveid);
        $sqlQuery->setNumber($returnbuybill->billnameid);
        $sqlQuery->setNumber($returnbuybill->returnbuybilldirectpayment);
        $sqlQuery->set($returnbuybill->dailyentryid);
        $sqlQuery->setNumber((int) $returnbuybill->delbyuserid);
        $sqlQuery->setNumber((int) $returnbuybill->currencyId);
        $sqlQuery->setNumber((float) $returnbuybill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $returnbuybill->taxOfDiscountVal);

        $sqlQuery->setNumber($returnbuybill->returnbuybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM returnbuybill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByReturnbuybillSerial($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldate($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillsupplierid($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilltotaldeptafter($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldiscount($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldiscountrype($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilltotalbill($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillaftertotalbill($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilltotalpayed($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillfinalbill($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillstoreid($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillsysdate($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillclientname($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillsaveid($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldirectpayment($value) {
        $sql = 'SELECT * FROM returnbuybill WHERE returnbuybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByReturnbuybillSerial($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldate($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillsupplierid($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilltotaldeptbefor($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilltotaldeptafter($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldiscount($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldiscountrype($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilltotalbill($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillaftertotalbill($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilltotalpayed($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillfinalbill($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillstoreid($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillsysdate($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM returnbuybill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM returnbuybill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillclientname($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillsaveid($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM returnbuybill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldirectpayment($value) {
        $sql = 'DELETE FROM returnbuybill WHERE returnbuybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ReturnbuybillMySql
     */
    protected function readRow($row) {
        $returnbuybill = new Returnbuybill();

        $returnbuybill->returnbuybillid = isset($row['returnbuybillid']) ? $row['returnbuybillid'] : '';
        $returnbuybill->returnbuybillSerial = isset($row['returnbuybillSerial']) ? $row['returnbuybillSerial'] : '';
        $returnbuybill->returnbuybilldate = isset($row['returnbuybilldate']) ? $row['returnbuybilldate'] : '';
        $returnbuybill->returnbuybillsupplierid = isset($row['returnbuybillsupplierid']) ? $row['returnbuybillsupplierid'] : '';
        $returnbuybill->returnbuybilltotaldeptbefor = isset($row['returnbuybilltotaldeptbefor']) ? $row['returnbuybilltotaldeptbefor'] : '';
        $returnbuybill->returnbuybilltotaldeptafter = isset($row['returnbuybilltotaldeptafter']) ? $row['returnbuybilltotaldeptafter'] : '';
        $returnbuybill->returnbuybilldiscount = isset($row['returnbuybilldiscount']) ? $row['returnbuybilldiscount'] : '';
        $returnbuybill->returnbuybilldiscountrype = isset($row['returnbuybilldiscountrype']) ? $row['returnbuybilldiscountrype'] : '';
        $returnbuybill->returnbuybilltotalbill = isset($row['returnbuybilltotalbill']) ? $row['returnbuybilltotalbill'] : '';
        $returnbuybill->returnbuybillaftertotalbill = isset($row['returnbuybillaftertotalbill']) ? $row['returnbuybillaftertotalbill'] : '';
        $returnbuybill->returnbuybilltotalpayed = isset($row['returnbuybilltotalpayed']) ? $row['returnbuybilltotalpayed'] : '';
        $returnbuybill->returnbuybillfinalbill = isset($row['returnbuybillfinalbill']) ? $row['returnbuybillfinalbill'] : '';
        $returnbuybill->returnbuybillstoreid = isset($row['returnbuybillstoreid']) ? $row['returnbuybillstoreid'] : '';
        $returnbuybill->returnbuybillsysdate = isset($row['returnbuybillsysdate']) ? $row['returnbuybillsysdate'] : '';
        $returnbuybill->comment = isset($row['comment']) ? $row['comment'] : '';
        $returnbuybill->userid = isset($row['userid']) ? $row['userid'] : '';
        $returnbuybill->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $returnbuybill->returnbuybillclientname = isset($row['returnbuybillclientname']) ? $row['returnbuybillclientname'] : '';
        $returnbuybill->returnbuybillsaveid = isset($row['returnbuybillsaveid']) ? $row['returnbuybillsaveid'] : '';
        $returnbuybill->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $returnbuybill->returnbuybilldirectpayment = isset($row['returnbuybilldirectpayment']) ? $row['returnbuybilldirectpayment'] : '';
        $returnbuybill->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';

        $returnbuybill->deletedbuyid = isset($row['deletedbuyid']) ? $row['deletedbuyid'] : '';
        $returnbuybill->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $returnbuybill->payedtax = isset($row['payedtax']) ? $row['payedtax'] : '';
        $returnbuybill->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $returnbuybill->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';




        //required
        $returnbuybill->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $returnbuybill->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $returnbuybill->username = isset($row['username']) ? $row['username'] : '';
        $returnbuybill->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $returnbuybill->delbyuserid = isset($row['delbyuserid']) ? $row['delbyuserid'] : '';
        $returnbuybill->delbyusername = isset($row['delbyusername']) ? $row['delbyusername'] : '';
        $returnbuybill->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $returnbuybill->currencyName = isset($row['currencyName']) ? $row['currencyName'] : '';
        $returnbuybill->taxOfDiscountPer = isset($row['taxOfDiscountPer']) ? $row['taxOfDiscountPer'] : '';
        $returnbuybill->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $returnbuybill->allGenTotalReturn = isset($row['allGenTotalReturn']) ? $row['allGenTotalReturn'] : '';
        $returnbuybill->client = isset($row['client']) ? $row['client'] : '';


        return $returnbuybill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ReturnbuybillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>