<?php
/**
 * Class that operate on table 'restaurantprinter'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-03-20 13:33
 */
class RestaurantprinterMySqlDAO implements RestaurantprinterDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return RestaurantprinterMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM restaurantprinter WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM restaurantprinter';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM restaurantprinter ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param restaurantprinter primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM restaurantprinter WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param RestaurantprinterMySql restaurantprinter
 	 */
	public function insert($restaurantprinter){
		$sql = 'INSERT INTO restaurantprinter (name, cats, userid, sysdate, del) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($restaurantprinter->name);
		$sqlQuery->set($restaurantprinter->cats);
		$sqlQuery->setNumber($restaurantprinter->userid);
		$sqlQuery->set($restaurantprinter->sysdate);
		$sqlQuery->setNumber($restaurantprinter->del);

		$id = $this->executeInsert($sqlQuery);	
		$restaurantprinter->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param RestaurantprinterMySql restaurantprinter
 	 */
	public function update($restaurantprinter){
		$sql = 'UPDATE restaurantprinter SET name = ?, cats = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($restaurantprinter->name);
		$sqlQuery->set($restaurantprinter->cats);
		$sqlQuery->setNumber($restaurantprinter->userid);
		$sqlQuery->set($restaurantprinter->sysdate);
		$sqlQuery->setNumber($restaurantprinter->del);

		$sqlQuery->setNumber($restaurantprinter->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM restaurantprinter';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByName($value){
		$sql = 'SELECT * FROM restaurantprinter WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCats($value){
		$sql = 'SELECT * FROM restaurantprinter WHERE cats = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM restaurantprinter WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM restaurantprinter WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM restaurantprinter WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByName($value){
		$sql = 'DELETE FROM restaurantprinter WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCats($value){
		$sql = 'DELETE FROM restaurantprinter WHERE cats = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM restaurantprinter WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM restaurantprinter WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM restaurantprinter WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return RestaurantprinterMySql 
	 */
	protected function readRow($row){
		$restaurantprinter = new Restaurantprinter();
		
		$restaurantprinter->id = $row['id'];
		$restaurantprinter->name = $row['name'];
		$restaurantprinter->cats = $row['cats'];
		$restaurantprinter->userid = $row['userid'];
		$restaurantprinter->sysdate = $row['sysdate'];
		$restaurantprinter->del = $row['del'];

		return $restaurantprinter;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return RestaurantprinterMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>