<?php

/**
 * Class that operate on table 'representativecompany'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-25 14:24
 */
class RepresentativecompanyMySqlDAO implements RepresentativecompanyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RepresentativecompanyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM representativecompany WHERE representativecompanyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM representativecompany';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM representativecompany ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param representativecompany primary key
     */
    public function delete($representativecompanyId) {
        $sql = 'DELETE FROM representativecompany WHERE representativecompanyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($representativecompanyId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RepresentativecompanyMySql representativecompany
     */
    public function insert($representativecompany, $otherInfo) {
        $sql = 'INSERT INTO representativecompany (representativeName, representativePhone, companyId, otherInfo) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($representativecompany->representativeName);
        $sqlQuery->set($representativecompany->representativePhone);
        $sqlQuery->setNumber($representativecompany->companyId);
        $sqlQuery->setString2($otherInfo);

        $id = $this->executeInsert($sqlQuery);
        $representativecompany->representativecompanyId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RepresentativecompanyMySql representativecompany
     */
    public function update($representativecompany, $otherInfo) {
        $sql = 'UPDATE representativecompany SET representativeName = ?, representativePhone = ?, companyId = ?, otherInfo = ? WHERE representativecompanyId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($representativecompany->representativeName);
        $sqlQuery->set($representativecompany->representativePhone);
        $sqlQuery->setNumber($representativecompany->companyId);
        $sqlQuery->setString2($otherInfo);

        $sqlQuery->setNumber($representativecompany->representativecompanyId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM representativecompany';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRepresentativeName($value) {
        $sql = 'SELECT * FROM representativecompany WHERE representativeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRepresentativePhone($value) {
        $sql = 'SELECT * FROM representativecompany WHERE representativePhone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCompanyId($value) {
        $sql = 'SELECT * FROM representativecompany WHERE companyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOtherInfo($value) {
        $sql = 'SELECT * FROM representativecompany WHERE otherInfo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRepresentativeName($value) {
        $sql = 'DELETE FROM representativecompany WHERE representativeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRepresentativePhone($value) {
        $sql = 'DELETE FROM representativecompany WHERE representativePhone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCompanyId($value) {
        $sql = 'DELETE FROM representativecompany WHERE companyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOtherInfo($value) {
        $sql = 'DELETE FROM representativecompany WHERE otherInfo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RepresentativecompanyMySql
     */
    protected function readRow($row) {
        $representativecompany = new Representativecompany();

        $representativecompany->representativecompanyId = isset($row['representativecompanyId']) ? $row['representativecompanyId'] : '';
        $representativecompany->representativeName = isset($row['representativeName']) ? $row['representativeName'] : '';
        $representativecompany->representativePhone = isset($row['representativePhone']) ? $row['representativePhone'] : '';
        $representativecompany->companyId = isset($row['companyId']) ? $row['companyId'] : '';
        $representativecompany->otherInfo = isset($row['otherInfo']) ? $row['otherInfo'] : '';

        return $representativecompany;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RepresentativecompanyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>