<?php

/**
 * Class that operate on table 'rawmaterialscategory'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class RawmaterialscategoryMySqlDAO implements RawmaterialscategoryDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RawmaterialscategoryMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM rawmaterialscategory WHERE rawmaterialscategoryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM rawmaterialscategory';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM rawmaterialscategory ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param rawmaterialscategory primary key
     */
    public function delete($rawmaterialscategoryid) {
        $sql = 'DELETE FROM rawmaterialscategory WHERE rawmaterialscategoryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($rawmaterialscategoryid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RawmaterialscategoryMySql rawmaterialscategory
     */
    public function insert($rawmaterialscategory) {
        $sql = 'INSERT INTO rawmaterialscategory (rawmaterialscategoryname, rawmaterialscategorydescription, tempdelete, currentdate) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rawmaterialscategory->rawmaterialscategoryname);
        $sqlQuery->set($rawmaterialscategory->rawmaterialscategorydescription);
        $sqlQuery->setNumber($rawmaterialscategory->tempdelete);
        $sqlQuery->set($rawmaterialscategory->currentdate);

        $id = $this->executeInsert($sqlQuery);
        $rawmaterialscategory->rawmaterialscategoryid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RawmaterialscategoryMySql rawmaterialscategory
     */
    public function update($rawmaterialscategory) {
        $sql = 'UPDATE rawmaterialscategory SET rawmaterialscategoryname = ?, rawmaterialscategorydescription = ?, tempdelete = ?, currentdate = ? WHERE rawmaterialscategoryid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rawmaterialscategory->rawmaterialscategoryname);
        $sqlQuery->set($rawmaterialscategory->rawmaterialscategorydescription);
        $sqlQuery->setNumber($rawmaterialscategory->tempdelete);
        $sqlQuery->set($rawmaterialscategory->currentdate);

        $sqlQuery->setNumber($rawmaterialscategory->rawmaterialscategoryid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM rawmaterialscategory';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRawmaterialscategoryname($value) {
        $sql = 'SELECT * FROM rawmaterialscategory WHERE rawmaterialscategoryname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialscategorydescription($value) {
        $sql = 'SELECT * FROM rawmaterialscategory WHERE rawmaterialscategorydescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM rawmaterialscategory WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM rawmaterialscategory WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRawmaterialscategoryname($value) {
        $sql = 'DELETE FROM rawmaterialscategory WHERE rawmaterialscategoryname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialscategorydescription($value) {
        $sql = 'DELETE FROM rawmaterialscategory WHERE rawmaterialscategorydescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM rawmaterialscategory WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM rawmaterialscategory WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RawmaterialscategoryMySql
     */
    protected function readRow($row) {
        $rawmaterialscategory = new Rawmaterialscategory();

        $rawmaterialscategory->rawmaterialscategoryid = isset($row['rawmaterialscategoryid']) ? $row['rawmaterialscategoryid'] : '';
        $rawmaterialscategory->rawmaterialscategoryname = isset($row['rawmaterialscategoryname']) ? $row['rawmaterialscategoryname'] : '';
        $rawmaterialscategory->rawmaterialscategorydescription = isset($row['rawmaterialscategorydescription']) ? $row['rawmaterialscategorydescription'] : '';
        $rawmaterialscategory->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';
        $rawmaterialscategory->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';

        return $rawmaterialscategory;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RawmaterialscategoryMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>