<?php

/**
 * Class that operate on table 'productsetting'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-17 14:11
 */
class ProductsettingMySqlDAO implements ProductsettingDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductsettingMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productsetting WHERE productsettingid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productsetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productsetting ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productsetting primary key
     */
    public function delete($productsettingid) {
        $sql = 'DELETE FROM productsetting WHERE productsettingid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productsettingid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductsettingMySql productsetting
     */
    public function insert($productsetting) {
        $sql = 'INSERT INTO productsetting (leastValueAtStore, storeid) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productsetting->leastValueAtStore);
        $sqlQuery->setNumber($productsetting->storeid);

        $id = $this->executeInsert($sqlQuery);
        $productsetting->productsettingid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductsettingMySql productsetting
     */
    public function update($productsetting) {
        $sql = 'UPDATE productsetting SET leastValueAtStore = ?, storeid = ? WHERE productsettingid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productsetting->leastValueAtStore);
        $sqlQuery->setNumber($productsetting->storeid);

        $sqlQuery->setNumber($productsetting->productsettingid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productsetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByLeastValueAtStore($value) {
        $sql = 'SELECT * FROM productsetting WHERE leastValueAtStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM productsetting WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByLeastValueAtStore($value) {
        $sql = 'DELETE FROM productsetting WHERE leastValueAtStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM productsetting WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductsettingMySql
     */
    protected function readRow($row) {
        $productsetting = new Productsetting();

        $productsetting->productsettingid = isset($row['productsettingid']) ? $row['productsettingid'] : '';
        $productsetting->leastValueAtStore = isset($row['leastValueAtStore']) ? $row['leastValueAtStore'] : '';
        $productsetting->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        return $productsetting;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductsettingMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>