<?php

/**
 * Class that operate on table 'productionoutmanyinproducts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
class ProductionoutmanyinproductsMySqlDAO implements ProductionoutmanyinproductsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionoutmanyinproductsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionoutmanyinproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionoutmanyinproducts ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionoutmanyinproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionoutmanyinproductsMySql productionoutmanyinproduct
     */
    public function insert($productionoutmanyinproduct) {
        $sql = 'INSERT INTO productionoutmanyinproducts (productionoutmanyid, productid, sizeid, colorid, prounitid, quantity, unitpriceraw, unitManufPrice, inTotalCostUnit, inTotalCost) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmanyinproduct->productionoutmanyid);
        $sqlQuery->setNumber($productionoutmanyinproduct->productid);
        $sqlQuery->setNumber($productionoutmanyinproduct->sizeid);
        $sqlQuery->setNumber($productionoutmanyinproduct->colorid);
        $sqlQuery->setNumber($productionoutmanyinproduct->prounitid);
        $sqlQuery->set($productionoutmanyinproduct->quantity);
        $sqlQuery->set($productionoutmanyinproduct->unitpriceraw);
        $sqlQuery->set($productionoutmanyinproduct->unitManufPrice);
        $sqlQuery->set($productionoutmanyinproduct->inTotalCostUnit);
        $sqlQuery->set($productionoutmanyinproduct->inTotalCost);

        $id = $this->executeInsert($sqlQuery);
        $productionoutmanyinproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionoutmanyinproductsMySql productionoutmanyinproduct
     */
    public function update($productionoutmanyinproduct) {
        $sql = 'UPDATE productionoutmanyinproducts SET productionoutmanyid = ?, productid = ?, sizeid = ?, colorid = ?, prounitid = ?, quantity = ?, unitpriceraw = ?, unitManufPrice = ?, inTotalCostUnit = ?, inTotalCost = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmanyinproduct->productionoutmanyid);
        $sqlQuery->setNumber($productionoutmanyinproduct->productid);
        $sqlQuery->setNumber($productionoutmanyinproduct->sizeid);
        $sqlQuery->setNumber($productionoutmanyinproduct->colorid);
        $sqlQuery->setNumber($productionoutmanyinproduct->prounitid);
        $sqlQuery->set($productionoutmanyinproduct->quantity);
        $sqlQuery->set($productionoutmanyinproduct->unitpriceraw);
        $sqlQuery->set($productionoutmanyinproduct->unitManufPrice);
        $sqlQuery->set($productionoutmanyinproduct->inTotalCostUnit);
        $sqlQuery->set($productionoutmanyinproduct->inTotalCost);

        $sqlQuery->setNumber($productionoutmanyinproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionoutmanyinproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductionoutmanyid($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE productionoutmanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProunitid($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE prounitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitpriceraw($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE unitpriceraw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitManufPrice($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE unitManufPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInTotalCostUnit($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE inTotalCostUnit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInTotalCost($value) {
        $sql = 'SELECT * FROM productionoutmanyinproducts WHERE inTotalCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductionoutmanyid($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE productionoutmanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProunitid($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE prounitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitpriceraw($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE unitpriceraw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitManufPrice($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE unitManufPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInTotalCostUnit($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE inTotalCostUnit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInTotalCost($value) {
        $sql = 'DELETE FROM productionoutmanyinproducts WHERE inTotalCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionoutmanyinproductsMySql
     */
    protected function readRow($row) {
        $productionoutmanyinproduct = new Productionoutmanyinproduct();

        $productionoutmanyinproduct->id = $row['id'];
        $productionoutmanyinproduct->productionoutmanyid = $row['productionoutmanyid'];
        $productionoutmanyinproduct->productid = $row['productid'];
        $productionoutmanyinproduct->sizeid = $row['sizeid'];
        $productionoutmanyinproduct->colorid = $row['colorid'];
        $productionoutmanyinproduct->prounitid = $row['prounitid'];
        $productionoutmanyinproduct->quantity = $row['quantity'];
        $productionoutmanyinproduct->unitpriceraw = $row['unitpriceraw'];
        $productionoutmanyinproduct->unitManufPrice = $row['unitManufPrice'];
        $productionoutmanyinproduct->inTotalCostUnit = $row['inTotalCostUnit'];
        $productionoutmanyinproduct->inTotalCost = $row['inTotalCost'];
        //
        $productionoutmanyinproduct->productName = $row['productName'];
        $productionoutmanyinproduct->productCatName = $row['productCatName'];
        $productionoutmanyinproduct->sizeName = $row['sizeName'];
        $productionoutmanyinproduct->colorName = $row['colorName'];
        $productionoutmanyinproduct->productnumber = $row['productnumber'];
        $productionoutmanyinproduct->unitName = $row['unitName'];

        return $productionoutmanyinproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionoutmanyinproductsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>