<?php

/**
 * Class that operate on table 'productionoutdetails'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-10-26 23:14
 */
class ProductionoutdetailsMySqlDAO implements ProductionoutdetailsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionoutdetailsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionoutdetails WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionoutdetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionoutdetails ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionoutdetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionoutdetails WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionoutdetailsMySql productionoutdetail
     */
    public function insert($productionoutdetail) {
        $sql = 'INSERT INTO productionoutdetails (productionOutId, productid, sizeid, colorid, unitid, price, quantity, inTotalCost) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutdetail->productionOutId);
        $sqlQuery->setNumber($productionoutdetail->productid);
        $sqlQuery->setNumber($productionoutdetail->sizeid);
        $sqlQuery->setNumber($productionoutdetail->colorid);
        $sqlQuery->setNumber($productionoutdetail->unitid);
        $sqlQuery->set($productionoutdetail->price);
        $sqlQuery->set($productionoutdetail->quantity);
        $sqlQuery->set($productionoutdetail->inTotalCost);

        $id = $this->executeInsert($sqlQuery);
        $productionoutdetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionoutdetailsMySql productionoutdetail
     */
    public function update($productionoutdetail) {
        $sql = 'UPDATE productionoutdetails SET productionOutId = ?, productid = ?, sizeid = ?, colorid = ?, unitid = ?, price = ?, quantity = ?, inTotalCost = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutdetail->productionOutId);
        $sqlQuery->setNumber($productionoutdetail->productid);
        $sqlQuery->setNumber($productionoutdetail->sizeid);
        $sqlQuery->setNumber($productionoutdetail->colorid);
        $sqlQuery->setNumber($productionoutdetail->unitid);
        $sqlQuery->set($productionoutdetail->price);
        $sqlQuery->set($productionoutdetail->quantity);
        $sqlQuery->set($productionoutdetail->inTotalCost);

        $sqlQuery->setNumber($productionoutdetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionoutdetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductionOutId($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE productionOutId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitid($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrice($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInTotalCost($value) {
        $sql = 'SELECT * FROM productionoutdetails WHERE inTotalCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductionOutId($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE productionOutId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitid($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrice($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInTotalCost($value) {
        $sql = 'DELETE FROM productionoutdetails WHERE inTotalCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionoutdetailsMySql
     */
    protected function readRow($row) {
        $productionoutdetail = new Productionoutdetail();

        $productionoutdetail->id = $row['id'];
        $productionoutdetail->productionOutId = $row['productionOutId'];
        $productionoutdetail->productid = $row['productid'];
        $productionoutdetail->sizeid = $row['sizeid'];
        $productionoutdetail->colorid = $row['colorid'];
        $productionoutdetail->unitid = $row['unitid'];
        $productionoutdetail->price = $row['price'];
        $productionoutdetail->quantity = $row['quantity'];
        $productionoutdetail->inTotalCost = $row['inTotalCost'];
        //
        $productionoutdetail->productName = $row['productName'];
        $productionoutdetail->productCatName = $row['productCatName'];
        $productionoutdetail->sizeName = $row['sizeName'];
        $productionoutdetail->colorName = $row['colorName'];
        $productionoutdetail->productnumber = $row['productnumber'];
        $productionoutdetail->unitName = $row['unitName'];

        return $productionoutdetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionoutdetailsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>