<?php

/**
 * Class that operate on table 'otherstoremovement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-05-11 13:57
 */
class OtherstoremovementMySqlDAO implements OtherstoremovementDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OtherstoremovementMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM otherstoremovement WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM otherstoremovement';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM otherstoremovement ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param otherstoremovement primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM otherstoremovement WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OtherstoremovementMySql otherstoremovement
     */
    public function insert($otherstoremovement) {
        $sql = 'INSERT INTO otherstoremovement (oprationnumber, deloperation, del, userid,comment,oprationdata) VALUES (?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($otherstoremovement->oprationnumber);
        $sqlQuery->setNumber($otherstoremovement->deloperation);
        $sqlQuery->setNumber($otherstoremovement->del);
        $sqlQuery->setNumber($otherstoremovement->userid);
        $sqlQuery->set($otherstoremovement->comment);
        $sqlQuery->set($otherstoremovement->oprationdata);


        $id = $this->executeInsert($sqlQuery);
        $otherstoremovement->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OtherstoremovementMySql otherstoremovement
     */
    public function update($otherstoremovement) {
        $sql = 'UPDATE otherstoremovement SET oprationnumber = ?, deloperation = ?, del = ?, userid = ? ,comment =? ,oprationdata= ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($otherstoremovement->oprationnumber);
        $sqlQuery->setNumber($otherstoremovement->deloperation);
        $sqlQuery->setNumber($otherstoremovement->del);
        $sqlQuery->setNumber($otherstoremovement->userid);
        $sqlQuery->set($otherstoremovement->comment);
        $sqlQuery->set($otherstoremovement->oprationdata);


        $sqlQuery->setNumber($otherstoremovement->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM otherstoremovement';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOprationnumber($value) {
        $sql = 'SELECT * FROM otherstoremovement WHERE oprationnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeloperation($value) {
        $sql = 'SELECT * FROM otherstoremovement WHERE deloperation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM otherstoremovement WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM otherstoremovement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOprationnumber($value) {
        $sql = 'DELETE FROM otherstoremovement WHERE oprationnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeloperation($value) {
        $sql = 'DELETE FROM otherstoremovement WHERE deloperation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM otherstoremovement WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM otherstoremovement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OtherstoremovementMySql
     */
    protected function readRow($row) {
        $otherstoremovement = new Otherstoremovement();

        $otherstoremovement->id = isset($row['id']) ? $row['id'] : '';
        $otherstoremovement->oprationnumber = isset($row['oprationnumber']) ? $row['oprationnumber'] : '';
        $otherstoremovement->deloperation = isset($row['deloperation']) ? $row['deloperation'] : '';
        $otherstoremovement->del = isset($row['del']) ? $row['del'] : '';
        $otherstoremovement->userid = isset($row['userid']) ? $row['userid'] : '';
        $otherstoremovement->comment = isset($row['comment']) ? $row['comment'] : '';
        $otherstoremovement->oprationdata = isset($row['oprationdata']) ? $row['oprationdata'] : '';


        return $otherstoremovement;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OtherstoremovementMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>