<?php
/**
 * Class that operate on table 'onlinetempstoredetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-11-13 10:55
 */
class OnlinetempstoredetailMySqlDAO implements OnlinetempstoredetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OnlinetempstoredetailMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM onlinetempstoredetail';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM onlinetempstoredetail ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param onlinetempstoredetail primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OnlinetempstoredetailMySql onlinetempstoredetail
 	 */
	public function insert($onlinetempstoredetail){
		$sql = 'INSERT INTO onlinetempstoredetail (storeid, productid, sizeid, colorid, quantity, edited, sysdate, userid) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlinetempstoredetail->storeid);
		$sqlQuery->setNumber($onlinetempstoredetail->productid);
		$sqlQuery->setNumber($onlinetempstoredetail->sizeid);
		$sqlQuery->setNumber($onlinetempstoredetail->colorid);
		$sqlQuery->set($onlinetempstoredetail->quantity);
		$sqlQuery->setNumber($onlinetempstoredetail->edited);
		$sqlQuery->set($onlinetempstoredetail->sysdate);
		$sqlQuery->setNumber($onlinetempstoredetail->userid);

		$id = $this->executeInsert($sqlQuery);	
		$onlinetempstoredetail->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OnlinetempstoredetailMySql onlinetempstoredetail
 	 */
	public function update($onlinetempstoredetail){
		$sql = 'UPDATE onlinetempstoredetail SET storeid = ?, productid = ?, sizeid = ?, colorid = ?, quantity = ?, edited = ?, sysdate = ?, userid = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlinetempstoredetail->storeid);
		$sqlQuery->setNumber($onlinetempstoredetail->productid);
		$sqlQuery->setNumber($onlinetempstoredetail->sizeid);
		$sqlQuery->setNumber($onlinetempstoredetail->colorid);
		$sqlQuery->set($onlinetempstoredetail->quantity);
		$sqlQuery->setNumber($onlinetempstoredetail->edited);
		$sqlQuery->set($onlinetempstoredetail->sysdate);
		$sqlQuery->setNumber($onlinetempstoredetail->userid);

		$sqlQuery->setNumber($onlinetempstoredetail->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM onlinetempstoredetail';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByStoreid($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE storeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySizeid($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE sizeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByColorid($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE colorid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByQuantity($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEdited($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE edited = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM onlinetempstoredetail WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByStoreid($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE storeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductid($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySizeid($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE sizeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByColorid($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE colorid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByQuantity($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEdited($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE edited = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM onlinetempstoredetail WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OnlinetempstoredetailMySql 
	 */
	protected function readRow($row){
		$onlinetempstoredetail = new Onlinetempstoredetail();
		
		$onlinetempstoredetail->id = $row['id'];
		$onlinetempstoredetail->storeid = $row['storeid'];
		$onlinetempstoredetail->productid = $row['productid'];
		$onlinetempstoredetail->sizeid = $row['sizeid'];
		$onlinetempstoredetail->colorid = $row['colorid'];
		$onlinetempstoredetail->quantity = $row['quantity'];
		$onlinetempstoredetail->edited = $row['edited'];
		$onlinetempstoredetail->sysdate = $row['sysdate'];
		$onlinetempstoredetail->userid = $row['userid'];

		return $onlinetempstoredetail;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OnlinetempstoredetailMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>