<?php

/**
 * Class that operate on table 'onlinetemporderproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-11-13 10:55
 */
class OnlinetemporderproductMySqlDAO implements OnlinetemporderproductDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OnlinetemporderproductMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM onlinetemporderproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM onlinetemporderproduct ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param onlinetemporderproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OnlinetemporderproductMySql onlinetemporderproduct
     */
    public function insert($onlinetemporderproduct) {
        $sql = 'INSERT INTO onlinetemporderproduct (orderid, productid, sizeid, price, quantity, shippingcost, total, orderstatus, shippingtype, discountprice) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetemporderproduct->orderid);
        $sqlQuery->setNumber($onlinetemporderproduct->productid);
        $sqlQuery->set($onlinetemporderproduct->sizeid);
        $sqlQuery->set($onlinetemporderproduct->price);
        $sqlQuery->set($onlinetemporderproduct->quantity);
        $sqlQuery->set($onlinetemporderproduct->shippingcost);
        $sqlQuery->set($onlinetemporderproduct->total);
        $sqlQuery->setNumber($onlinetemporderproduct->orderstatus);
        $sqlQuery->set($onlinetemporderproduct->shippingtype);
        $sqlQuery->set($onlinetemporderproduct->discountprice);

        $id = $this->executeInsert($sqlQuery);
        $onlinetemporderproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OnlinetemporderproductMySql onlinetemporderproduct
     */
    public function update($onlinetemporderproduct) {
        $sql = 'UPDATE onlinetemporderproduct SET orderid = ?, productid = ?, sizeid = ?, price = ?, quantity = ?, shippingcost = ?, total = ?, orderstatus = ?, shippingtype = ?, discountprice = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetemporderproduct->orderid);
        $sqlQuery->setNumber($onlinetemporderproduct->productid);
        $sqlQuery->set($onlinetemporderproduct->sizeid);
        $sqlQuery->set($onlinetemporderproduct->price);
        $sqlQuery->set($onlinetemporderproduct->quantity);
        $sqlQuery->set($onlinetemporderproduct->shippingcost);
        $sqlQuery->set($onlinetemporderproduct->total);
        $sqlQuery->setNumber($onlinetemporderproduct->orderstatus);
        $sqlQuery->set($onlinetemporderproduct->shippingtype);
        $sqlQuery->set($onlinetemporderproduct->discountprice);

        $sqlQuery->setNumber($onlinetemporderproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM onlinetemporderproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrderid($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE orderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrice($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShippingcost($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE shippingcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotal($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE total = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrderstatus($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE orderstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShippingtype($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE shippingtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountprice($value) {
        $sql = 'SELECT * FROM onlinetemporderproduct WHERE discountprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOrderid($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE orderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrice($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShippingcost($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE shippingcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotal($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE total = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrderstatus($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE orderstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShippingtype($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE shippingtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountprice($value) {
        $sql = 'DELETE FROM onlinetemporderproduct WHERE discountprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OnlinetemporderproductMySql
     */
    protected function readRow($row) {
        $onlinetemporderproduct = new Onlinetemporderproduct();

        $onlinetemporderproduct->id = $row['id'];
        $onlinetemporderproduct->orderid = $row['orderid'];
        $onlinetemporderproduct->productid = $row['productid'];
        $onlinetemporderproduct->sizeid = $row['sizeid'];
        $onlinetemporderproduct->price = $row['price'];
        $onlinetemporderproduct->quantity = $row['quantity'];
        $onlinetemporderproduct->shippingcost = $row['shippingcost'];
        $onlinetemporderproduct->total = $row['total'];
        $onlinetemporderproduct->orderstatus = $row['orderstatus'];
        $onlinetemporderproduct->shippingtype = $row['shippingtype'];
        $onlinetemporderproduct->discountprice = $row['discountprice'];
        //
        $onlinetemporderproduct->productName = $row['productName'];
        $onlinetemporderproduct->productCatName = $row['productCatName'];

        return $onlinetemporderproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OnlinetemporderproductMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>