<?php

/**
 * Class that operate on table 'employeegroup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-11 22:24
 */
class EmployeegroupMySqlDAO implements EmployeegroupDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeegroupMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employeegroup WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employeegroup';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employeegroup ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employeegroup primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM employeegroup WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeegroupMySql employeegroup
     */
    public function insert($employeegroup) {
        $sql = 'INSERT INTO employeegroup (name, employeeattendancesystemid, userid, del, sysdate) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($employeegroup->name);
        $sqlQuery->setNumber($employeegroup->employeeattendancesystemid);
        $sqlQuery->setNumber($employeegroup->userid);
        $sqlQuery->setNumber($employeegroup->del);
        $sqlQuery->set($employeegroup->sysdate);

        $id = $this->executeInsert($sqlQuery);
        $employeegroup->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeegroupMySql employeegroup
     */
    public function update($employeegroup) {
        $sql = 'UPDATE employeegroup SET name = ?, employeeattendancesystemid = ?, userid = ?, del = ?, sysdate = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($employeegroup->name);
        $sqlQuery->setNumber($employeegroup->employeeattendancesystemid);
        $sqlQuery->setNumber($employeegroup->userid);
        $sqlQuery->setNumber($employeegroup->del);
        $sqlQuery->set($employeegroup->sysdate);

        $sqlQuery->setNumber($employeegroup->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employeegroup';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM employeegroup WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeattendancesystemid($value) {
        $sql = 'SELECT * FROM employeegroup WHERE employeeattendancesystemid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM employeegroup WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM employeegroup WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM employeegroup WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM employeegroup WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeattendancesystemid($value) {
        $sql = 'DELETE FROM employeegroup WHERE employeeattendancesystemid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM employeegroup WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM employeegroup WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM employeegroup WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeegroupMySql
     */
    protected function readRow($row) {
        $employeegroup = new Employeegroup();

        $employeegroup->id = $row['id'];
        $employeegroup->name = $row['name'];
        $employeegroup->employeeattendancesystemid = $row['employeeattendancesystemid'];
        $employeegroup->userid = $row['userid'];
        $employeegroup->del = $row['del'];
        $employeegroup->sysdate = $row['sysdate'];
        //
        $employeegroup->status = $row['status'];

        return $employeegroup;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeegroupMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>