<?php
/**
 * Class that operate on table 'employeeclosedaysubgroupstatus'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-19 05:41
 */
class EmployeeclosedaysubgroupstatusMySqlDAO implements EmployeeclosedaysubgroupstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return EmployeeclosedaysubgroupstatusMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param employeeclosedaysubgroupstatu primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param EmployeeclosedaysubgroupstatusMySql employeeclosedaysubgroupstatu
 	 */
	public function insert($employeeclosedaysubgroupstatu){
		$sql = 'INSERT INTO employeeclosedaysubgroupstatus (day, employeesubgroupid, status, userid, sysdate, conditions) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeclosedaysubgroupstatu->day);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->employeesubgroupid);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->status);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->userid);
		$sqlQuery->set($employeeclosedaysubgroupstatu->sysdate);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->conditions);

		$id = $this->executeInsert($sqlQuery);	
		$employeeclosedaysubgroupstatu->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param EmployeeclosedaysubgroupstatusMySql employeeclosedaysubgroupstatu
 	 */
	public function update($employeeclosedaysubgroupstatu){
		$sql = 'UPDATE employeeclosedaysubgroupstatus SET day = ?, employeesubgroupid = ?, status = ?, userid = ?, sysdate = ?, conditions = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeclosedaysubgroupstatu->day);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->employeesubgroupid);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->status);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->userid);
		$sqlQuery->set($employeeclosedaysubgroupstatu->sysdate);
		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->conditions);

		$sqlQuery->setNumber($employeeclosedaysubgroupstatu->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByDay($value){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEmployeesubgroupid($value){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus WHERE employeesubgroupid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM employeeclosedaysubgroupstatus WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByDay($value){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEmployeesubgroupid($value){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus WHERE employeesubgroupid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM employeeclosedaysubgroupstatus WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return EmployeeclosedaysubgroupstatusMySql 
	 */
	protected function readRow($row){
		$employeeclosedaysubgroupstatu = new Employeeclosedaysubgroupstatu();
		
		$employeeclosedaysubgroupstatu->id = $row['id'];
		$employeeclosedaysubgroupstatu->day = $row['day'];
		$employeeclosedaysubgroupstatu->employeesubgroupid = $row['employeesubgroupid'];
		$employeeclosedaysubgroupstatu->status = $row['status'];
		$employeeclosedaysubgroupstatu->userid = $row['userid'];
		$employeeclosedaysubgroupstatu->sysdate = $row['sysdate'];
		$employeeclosedaysubgroupstatu->conditions = $row['conditions'];

		return $employeeclosedaysubgroupstatu;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return EmployeeclosedaysubgroupstatusMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>