<?php

/**
 * Class that operate on table 'currency'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-10-13 23:11
 */
class CurrencyMySqlDAO implements CurrencyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CurrencyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM currency WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM currency';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM currency ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param currency primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM currency WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CurrencyMySql currency
     */
    public function insert($currency) {
        $sql = 'INSERT INTO currency (name, symbol, conversionFactor, conditions, userid, sysDate,otherconversionFactor) VALUES (?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($currency->name);
        $sqlQuery->set($currency->symbol);
        $sqlQuery->set($currency->conversionFactor);
        $sqlQuery->setNumber($currency->conditions);
        $sqlQuery->setNumber($currency->userid);
        $sqlQuery->set($currency->sysDate);
        $sqlQuery->setNumber($currency->otherconversionFactor);

        $id = $this->executeInsert($sqlQuery);
        $currency->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CurrencyMySql currency
     */
    public function update($currency) {
        $sql = 'UPDATE currency SET name = ?, symbol = ?, conversionFactor = ?, conditions = ?, userid = ?, sysDate = ?,otherconversionFactor=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($currency->name);
        $sqlQuery->set($currency->symbol);
        $sqlQuery->set($currency->conversionFactor);
        $sqlQuery->setNumber($currency->conditions);
        $sqlQuery->setNumber($currency->userid);
        $sqlQuery->set($currency->sysDate);
        $sqlQuery->setNumber($currency->otherconversionFactor);

        $sqlQuery->setNumber($currency->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM currency';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM currency WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySymbol($value) {
        $sql = 'SELECT * FROM currency WHERE symbol = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConversionFactor($value) {
        $sql = 'SELECT * FROM currency WHERE conversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM currency WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM currency WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM currency WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM currency WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySymbol($value) {
        $sql = 'DELETE FROM currency WHERE symbol = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConversionFactor($value) {
        $sql = 'DELETE FROM currency WHERE conversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM currency WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM currency WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM currency WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CurrencyMySql
     */
    protected function readRow($row) {
        $currency = new Currency();

        $currency->id = $row['id'];
        $currency->name = $row['name'];
        $currency->symbol = $row['symbol'];
        $currency->conversionFactor = $row['conversionFactor'];
        $currency->conditions = $row['conditions'];
        $currency->userid = $row['userid'];
        $currency->sysDate = $row['sysDate'];
        $currency->otherconversionFactor = $row['otherconversionFactor'];

        return $currency;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CurrencyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>