<?php

/**
 * Class that operate on table 'buybilloffer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-01-05 22:09
 */
class BuybillofferMySqlDAO implements BuybillofferDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BuybillofferMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM buybilloffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM buybilloffer ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param buybilloffer primary key
     */
    public function delete($buybillid) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($buybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BuybillofferMySql buybilloffer
     */
    public function insert($buybilloffer) {
        $sql = 'INSERT INTO buybilloffer (buybillSerial, buybilldate, buybillsupplierid, buybilltotaldeptbefor, buybilltotaldeptafter, buybilldiscount, buybilldiscountrype, buybilltotalbill, buybillaftertotalbill, buybilltotalpayed, buybillfinalbill, buybillstoreid, buybillsysdate, comment, userid, conditions, buybillclientname, buybillsaveid, buybilldirectpayment, billnameid, deletedbuyid, controlname, payedtax, costcenterid, dailyentryid, delbyuserid, currencyId,orderSavedBillId,taxOfDiscountPer,taxOfDiscountVal,webApiId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybilloffer->buybillSerial);
        $sqlQuery->set($buybilloffer->buybilldate);
        $sqlQuery->setNumber($buybilloffer->buybillsupplierid);
        $sqlQuery->set($buybilloffer->buybilltotaldeptbefor);
        $sqlQuery->set($buybilloffer->buybilltotaldeptafter);
        $sqlQuery->set($buybilloffer->buybilldiscount);
        $sqlQuery->setNumber($buybilloffer->buybilldiscountrype);
        $sqlQuery->set($buybilloffer->buybilltotalbill);
        $sqlQuery->set($buybilloffer->buybillaftertotalbill);
        $sqlQuery->set($buybilloffer->buybilltotalpayed);
        $sqlQuery->set($buybilloffer->buybillfinalbill);
        $sqlQuery->setNumber($buybilloffer->buybillstoreid);
        $sqlQuery->set($buybilloffer->buybillsysdate);
        $sqlQuery->setString2($buybilloffer->comment);
        $sqlQuery->setNumber($buybilloffer->userid);
        $sqlQuery->setNumber($buybilloffer->conditions);
        $sqlQuery->set($buybilloffer->buybillclientname);
        $sqlQuery->setNumber($buybilloffer->buybillsaveid);
        $sqlQuery->setNumber($buybilloffer->buybilldirectpayment);
        $sqlQuery->setNumber($buybilloffer->billnameid);
        $sqlQuery->setNumber($buybilloffer->deletedbuyid);
        $sqlQuery->set($buybilloffer->controlname);
        $sqlQuery->set($buybilloffer->payedtax);
        $sqlQuery->setNumber($buybilloffer->costcenterid);
        $sqlQuery->setNumber($buybilloffer->dailyentryid);
        $sqlQuery->setNumber($buybilloffer->delbyuserid);
        $sqlQuery->setNumber($buybilloffer->currencyId);
        $sqlQuery->setNumber((int) $buybilloffer->orderSavedBillId);
        $sqlQuery->setNumber((float) $buybilloffer->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $buybilloffer->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $buybilloffer->webApiId);

        $id = $this->executeInsert($sqlQuery);
        $buybilloffer->buybillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BuybillofferMySql buybilloffer
     */
    public function update($buybilloffer) {
        $sql = 'UPDATE buybilloffer SET buybillSerial = ?, buybilldate = ?, buybillsupplierid = ?, buybilltotaldeptbefor = ?, buybilltotaldeptafter = ?, buybilldiscount = ?, buybilldiscountrype = ?, buybilltotalbill = ?, buybillaftertotalbill = ?, buybilltotalpayed = ?, buybillfinalbill = ?, buybillstoreid = ?, buybillsysdate = ?, comment = ?, userid = ?, conditions = ?, buybillclientname = ?, buybillsaveid = ?, buybilldirectpayment = ?, billnameid = ?, deletedbuyid = ?, controlname = ?, payedtax = ?, costcenterid = ?, dailyentryid = ?, delbyuserid = ?, currencyId = ?,orderSavedBillId=?,taxOfDiscountPer=?,taxOfDiscountVal=? WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybilloffer->buybillSerial);
        $sqlQuery->set($buybilloffer->buybilldate);
        $sqlQuery->setNumber($buybilloffer->buybillsupplierid);
        $sqlQuery->set($buybilloffer->buybilltotaldeptbefor);
        $sqlQuery->set($buybilloffer->buybilltotaldeptafter);
        $sqlQuery->set($buybilloffer->buybilldiscount);
        $sqlQuery->setNumber($buybilloffer->buybilldiscountrype);
        $sqlQuery->set($buybilloffer->buybilltotalbill);
        $sqlQuery->set($buybilloffer->buybillaftertotalbill);
        $sqlQuery->set($buybilloffer->buybilltotalpayed);
        $sqlQuery->set($buybilloffer->buybillfinalbill);
        $sqlQuery->setNumber($buybilloffer->buybillstoreid);
        $sqlQuery->set($buybilloffer->buybillsysdate);
        $sqlQuery->setString2($buybilloffer->comment);
        $sqlQuery->setNumber($buybilloffer->userid);
        $sqlQuery->setNumber($buybilloffer->conditions);
        $sqlQuery->set($buybilloffer->buybillclientname);
        $sqlQuery->setNumber($buybilloffer->buybillsaveid);
        $sqlQuery->setNumber($buybilloffer->buybilldirectpayment);
        $sqlQuery->setNumber($buybilloffer->billnameid);
        $sqlQuery->setNumber($buybilloffer->deletedbuyid);
        $sqlQuery->set($buybilloffer->controlname);
        $sqlQuery->set($buybilloffer->payedtax);
        $sqlQuery->setNumber($buybilloffer->costcenterid);
        $sqlQuery->setNumber($buybilloffer->dailyentryid);
        $sqlQuery->setNumber($buybilloffer->delbyuserid);
        $sqlQuery->setNumber($buybilloffer->currencyId);
        $sqlQuery->setNumber((int) $buybilloffer->orderSavedBillId);
        $sqlQuery->setNumber((float) $buybilloffer->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $buybilloffer->taxOfDiscountVal);

        $sqlQuery->setNumber($buybilloffer->buybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM buybilloffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuybillSerial($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldate($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsupplierid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotaldeptafter($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldiscount($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldiscountrype($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalbill($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillaftertotalbill($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalpayed($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillfinalbill($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillstoreid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsysdate($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillclientname($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsaveid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldirectpayment($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE buybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeletedbuyid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE deletedbuyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByControlname($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayedtax($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE payedtax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelbyuserid($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE delbyuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrencyId($value) {
        $sql = 'SELECT * FROM buybilloffer WHERE currencyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuybillSerial($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldate($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsupplierid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotaldeptbefor($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotaldeptafter($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldiscount($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldiscountrype($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalbill($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillaftertotalbill($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalpayed($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillfinalbill($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillstoreid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsysdate($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM buybilloffer WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM buybilloffer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillclientname($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsaveid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldirectpayment($value) {
        $sql = 'DELETE FROM buybilloffer WHERE buybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeletedbuyid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE deletedbuyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByControlname($value) {
        $sql = 'DELETE FROM buybilloffer WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayedtax($value) {
        $sql = 'DELETE FROM buybilloffer WHERE payedtax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelbyuserid($value) {
        $sql = 'DELETE FROM buybilloffer WHERE delbyuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrencyId($value) {
        $sql = 'DELETE FROM buybilloffer WHERE currencyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BuybillofferMySql
     */
    protected function readRow($row) {
        $buybilloffer = new Buybilloffer();

        $buybilloffer->buybillid = $row['buybillid'];
        $buybilloffer->buybillSerial = $row['buybillSerial'];
        $buybilloffer->buybilldate = $row['buybilldate'];
        $buybilloffer->buybillsupplierid = $row['buybillsupplierid'];
        $buybilloffer->buybilltotaldeptbefor = $row['buybilltotaldeptbefor'];
        $buybilloffer->buybilltotaldeptafter = $row['buybilltotaldeptafter'];
        $buybilloffer->buybilldiscount = $row['buybilldiscount'];
        $buybilloffer->buybilldiscountrype = $row['buybilldiscountrype'];
        $buybilloffer->buybilltotalbill = $row['buybilltotalbill'];
        $buybilloffer->buybillaftertotalbill = $row['buybillaftertotalbill'];
        $buybilloffer->buybilltotalpayed = $row['buybilltotalpayed'];
        $buybilloffer->buybillfinalbill = $row['buybillfinalbill'];
        $buybilloffer->buybillstoreid = $row['buybillstoreid'];
        $buybilloffer->buybillsysdate = $row['buybillsysdate'];
        $buybilloffer->comment = $row['comment'];
        $buybilloffer->userid = $row['userid'];
        $buybilloffer->conditions = $row['conditions'];
        $buybilloffer->buybillclientname = $row['buybillclientname'];
        $buybilloffer->buybillsaveid = $row['buybillsaveid'];
        $buybilloffer->buybilldirectpayment = $row['buybilldirectpayment'];
        $buybilloffer->billnameid = $row['billnameid'];
        $buybilloffer->deletedbuyid = $row['deletedbuyid'];
        $buybilloffer->controlname = $row['controlname'];
        $buybilloffer->payedtax = $row['payedtax'];
        $buybilloffer->costcenterid = $row['costcenterid'];
        $buybilloffer->dailyentryid = $row['dailyentryid'];
        $buybilloffer->delbyuserid = $row['delbyuserid'];
        $buybilloffer->currencyId = $row['currencyId'];
        $buybilloffer->orderSavedBillId = $row['orderSavedBillId'];
        //
        $buybilloffer->suppliername = $row['suppliername'];
        $buybilloffer->storeName = $row['storeName'];
        $buybilloffer->username = $row['username'];
        $buybilloffer->delbyusername = $row['delbyusername'];
        $buybilloffer->taxOfDiscountPer = isset($row['taxOfDiscountPer']) ? $row['taxOfDiscountPer'] : '';
        $buybilloffer->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $buybilloffer->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';

        return $buybilloffer;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BuybillofferMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>