<?php

/**
 * Class that operate on table 'billsreturnproducts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-08-06 13:48
 */
class BillsreturnproductsMySqlDAO implements BillsreturnproductsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillsreturnproductsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billsreturnproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billsreturnproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billsreturnproducts ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billsreturnproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM billsreturnproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillsreturnproductsMySql billsreturnproduct
     */
    public function insert($billsreturnproduct) {
        $sql = 'INSERT INTO billsreturnproducts (productid, returnbillid, productno, productprice, producttotalprice, deleted , billproductid,lastbuyprice,meanbuyprice) VALUES (?,?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsreturnproduct->productid);
        $sqlQuery->setNumber($billsreturnproduct->returnbillid);
        $sqlQuery->setNumber($billsreturnproduct->productno);
        $sqlQuery->set($billsreturnproduct->productprice);
        $sqlQuery->set($billsreturnproduct->producttotalprice);
        $sqlQuery->setNumber($billsreturnproduct->deleted);
        $sqlQuery->setNumber($billsreturnproduct->billproductid);

        $sqlQuery->set($billsreturnproduct->lastbuyprice);
        $sqlQuery->set($billsreturnproduct->meanbuyprice);

        $id = $this->executeInsert($sqlQuery);
        $billsreturnproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillsreturnproductsMySql billsreturnproduct
     */
    public function update($billsreturnproduct) {
        $sql = 'UPDATE billsreturnproducts SET productid = ?, returnbillid = ?, productno = ?, productprice = ?, producttotalprice = ?, deleted = ? , billproductid = ?,lastbuyprice = ?,meanbuyprice = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsreturnproduct->productid);
        $sqlQuery->setNumber($billsreturnproduct->returnbillid);
        $sqlQuery->setNumber($billsreturnproduct->productno);
        $sqlQuery->set($billsreturnproduct->productprice);
        $sqlQuery->set($billsreturnproduct->producttotalprice);
        $sqlQuery->setNumber($billsreturnproduct->deleted);
        $sqlQuery->setNumber($billsreturnproduct->billproductid);

        $sqlQuery->set($billsreturnproduct->lastbuyprice);
        $sqlQuery->set($billsreturnproduct->meanbuyprice);

        $sqlQuery->setNumber($billsreturnproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billsreturnproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM billsreturnproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbillid($value) {
        $sql = 'SELECT * FROM billsreturnproducts WHERE returnbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductno($value) {
        $sql = 'SELECT * FROM billsreturnproducts WHERE productno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductprice($value) {
        $sql = 'SELECT * FROM billsreturnproducts WHERE productprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProducttotalprice($value) {
        $sql = 'SELECT * FROM billsreturnproducts WHERE producttotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM billsreturnproducts WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM billsreturnproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbillid($value) {
        $sql = 'DELETE FROM billsreturnproducts WHERE returnbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductno($value) {
        $sql = 'DELETE FROM billsreturnproducts WHERE productno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductprice($value) {
        $sql = 'DELETE FROM billsreturnproducts WHERE productprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProducttotalprice($value) {
        $sql = 'DELETE FROM billsreturnproducts WHERE producttotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM billsreturnproducts WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillsreturnproductsMySql
     */
    protected function readRow($row) {
        $billsreturnproduct = new Billsreturnproduct();

        $billsreturnproduct->id = isset($row['id']) ? $row['id'] : '';
        $billsreturnproduct->productid = isset($row['productid']) ? $row['productid'] : '';
        $billsreturnproduct->returnbillid = isset($row['returnbillid']) ? $row['returnbillid'] : '';
        $billsreturnproduct->productno = isset($row['productno']) ? $row['productno'] : '';
        $billsreturnproduct->productprice = isset($row['productprice']) ? $row['productprice'] : '';
        $billsreturnproduct->producttotalprice = isset($row['producttotalprice']) ? $row['producttotalprice'] : '';
        $billsreturnproduct->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $billsreturnproduct->billproductid = isset($row['billproductid']) ? $row['billproductid'] : '';
        $billsreturnproduct->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $billsreturnproduct->sellbilldetaildate = isset($row['sellbilldetaildate']) ? $row['sellbilldetaildate'] : '';
        $billsreturnproduct->billtype = isset($row['billtype']) ? $row['billtype'] : '';
        $billsreturnproduct->productName = isset($row['productName']) ? $row['productName'] : '';
        $billsreturnproduct->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $billsreturnproduct->returnedprice = isset($row['returnedprice']) ? $row['returnedprice'] : '';
        $billsreturnproduct->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $billsreturnproduct->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $billsreturnproduct->clientid = isset($row['clientid']) ? $row['clientid'] : '';

        $billsreturnproduct->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $billsreturnproduct->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $billsreturnproduct->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';

        return $billsreturnproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillsreturnproductsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>