<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-26 14:08
 */
interface ToworkshoporderbillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Toworkshoporderbill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param toworkshoporderbill primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Toworkshoporderbill toworkshoporderbill
 	 */
	public function insert($toworkshoporderbill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Toworkshoporderbill toworkshoporderbill
 	 */
	public function update($toworkshoporderbill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByToworkshoporderid($value);

	public function queryByBillid($value);


	public function deleteByToworkshoporderid($value);

	public function deleteByBillid($value);


}
?>