<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
interface TemreturnsellbillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Temreturnsellbill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param temreturnsellbill primary key
 	 */
	public function delete($returnsellbillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Temreturnsellbill temreturnsellbill
 	 */
	public function insert($temreturnsellbill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Temreturnsellbill temreturnsellbill
 	 */
	public function update($temreturnsellbill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReturnsellbilldate($value);

	public function queryByReturnsellbillserial($value);

	public function queryByReturnsellbillclientid($value);

	public function queryByReturnsellbilltotaldeptbefor($value);

	public function queryByReturnsellbilltotaldeptafter($value);

	public function queryByReturnsellbilldiscount($value);

	public function queryByReturnsellbilldiscounttype($value);

	public function queryByReturnsellbilltotalbill($value);

	public function queryByReturnsellbillaftertotalbill($value);

	public function queryByReturnsellbilltotalpayed($value);

	public function queryByReturnsellbillfinalbill($value);

	public function queryByReturnsellbillstoreid($value);

	public function queryByReturnsellbillsysdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByReturnsellbillclientname($value);

	public function queryByReturnsellbillsaveid($value);

	public function queryByReturnsellbildirectpayment($value);

	public function queryByBillnameid($value);

	public function queryBySellerid($value);

	public function queryByTempclientName($value);

	public function queryByReturnsellQuantity($value);

	public function queryByDeletedsellid($value);

	public function queryByControlname($value);

	public function queryByTax($value);


	public function deleteByReturnsellbilldate($value);

	public function deleteByReturnsellbillserial($value);

	public function deleteByReturnsellbillclientid($value);

	public function deleteByReturnsellbilltotaldeptbefor($value);

	public function deleteByReturnsellbilltotaldeptafter($value);

	public function deleteByReturnsellbilldiscount($value);

	public function deleteByReturnsellbilldiscounttype($value);

	public function deleteByReturnsellbilltotalbill($value);

	public function deleteByReturnsellbillaftertotalbill($value);

	public function deleteByReturnsellbilltotalpayed($value);

	public function deleteByReturnsellbillfinalbill($value);

	public function deleteByReturnsellbillstoreid($value);

	public function deleteByReturnsellbillsysdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByReturnsellbillclientname($value);

	public function deleteByReturnsellbillsaveid($value);

	public function deleteByReturnsellbildirectpayment($value);

	public function deleteByBillnameid($value);

	public function deleteBySellerid($value);

	public function deleteByTempclientName($value);

	public function deleteByReturnsellQuantity($value);

	public function deleteByDeletedsellid($value);

	public function deleteByControlname($value);

	public function deleteByTax($value);


}
?>