<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface StoreDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Store 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param store primary key
 	 */
	public function delete($storeId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Store store
 	 */
	public function insert($store, $storeDescription);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Store store
 	 */
	public function update($store, $storeDescription);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreName($value);

	public function queryByStoreDate($value);

	public function queryByStoreDescription($value);

	public function queryByConditions($value);

	public function queryByUserId($value);


	public function deleteByStoreName($value);

	public function deleteByStoreDate($value);

	public function deleteByStoreDescription($value);

	public function deleteByConditions($value);

	public function deleteByUserId($value);


}
?>