<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-11-19 11:20
 */
interface SimplemanufacturesettingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Simplemanufacturesetting 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param simplemanufacturesetting primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Simplemanufacturesetting simplemanufacturesetting
 	 */
	public function insert($simplemanufacturesetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Simplemanufacturesetting simplemanufacturesetting
 	 */
	public function update($simplemanufacturesetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreid($value);

	public function queryByReducestoreamount($value);


	public function deleteByStoreid($value);

	public function deleteByReducestoreamount($value);


}
?>