<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-11-29 19:01
 */
interface SellbillstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sellbillstatus 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sellbillstatu primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sellbillstatus sellbillstatu
 	 */
	public function insert($sellbillstatu);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sellbillstatus sellbillstatu
 	 */
	public function update($sellbillstatu);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySellbillid($value);

	public function queryByStatus($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);


	public function deleteBySellbillid($value);

	public function deleteByStatus($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);


}
?>