<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-04-05 19:37
 */
interface RestaurantplaystationplayDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restaurantplaystationplay 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restaurantplaystationplay primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restaurantplaystationplay restaurantplaystationplay
 	 */
	public function insert($restaurantplaystationplay);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restaurantplaystationplay restaurantplaystationplay
 	 */
	public function update($restaurantplaystationplay);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPlaystationid($value);

	public function queryByHourPrice($value);

	public function queryByStartsysDate($value);

	public function queryByEndsysDate($value);

	public function queryByDuration($value);

	public function queryByNote($value);

	public function queryByTotalPrice($value);

	public function queryByDiscount($value);

	public function queryByTax($value);

	public function queryByNetPrice($value);

	public function queryByPayed($value);

	public function queryByFinished($value);

	public function queryBySellBillId($value);

	public function queryByUserId($value);

	public function queryBySysdate($value);

	public function queryByDel($value);

	public function queryByReservationType($value);

	public function queryByReservationHours($value);

	public function queryByReservationMinutes($value);

	public function queryByReservationEndDateTime($value);


	public function deleteByPlaystationid($value);

	public function deleteByHourPrice($value);

	public function deleteByStartsysDate($value);

	public function deleteByEndsysDate($value);

	public function deleteByDuration($value);

	public function deleteByNote($value);

	public function deleteByTotalPrice($value);

	public function deleteByDiscount($value);

	public function deleteByTax($value);

	public function deleteByNetPrice($value);

	public function deleteByPayed($value);

	public function deleteByFinished($value);

	public function deleteBySellBillId($value);

	public function deleteByUserId($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);

	public function deleteByReservationType($value);

	public function deleteByReservationHours($value);

	public function deleteByReservationMinutes($value);

	public function deleteByReservationEndDateTime($value);


}
?>