<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:38
 */
interface RestaurantorderdetailsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restaurantorderdetails 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restaurantorderdetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restaurantorderdetails restaurantorderdetail
 	 */
	public function insert($restaurantorderdetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restaurantorderdetails restaurantorderdetail
 	 */
	public function update($restaurantorderdetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOrderId($value);

	public function queryByProductId($value);

	public function queryByQuantity($value);

	public function queryByPrice($value);

	public function queryByTotal($value);

	public function queryByIsPrinted($value);


	public function deleteByOrderId($value);

	public function deleteByProductId($value);

	public function deleteByQuantity($value);

	public function deleteByPrice($value);

	public function deleteByTotal($value);

	public function deleteByIsPrinted($value);


}
?>