<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:06
 */
interface RentbillpropDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Rentbillprop 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param rentbillprop primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Rentbillprop rentbillprop
 	 */
	public function insert($rentbillprop);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Rentbillprop rentbillprop
 	 */
	public function update($rentbillprop);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillid($value);

	public function queryByProductid($value);

	public function queryByType($value);

	public function queryBySupplierid($value);

	public function queryByAmount($value);

	public function queryByRentprice($value);

	public function queryBySupplierprice($value);

	public function queryByTotalprice($value);

	public function queryBySuppliertotalpice($value);

	public function queryByStartdate($value);

	public function queryByEnddate($value);

	public function queryByRentdays($value);

	public function queryByStatus($value);

	public function queryByDelayvalue($value);

	public function queryByDelaytype($value);

	public function queryByDelypay($value);

	public function queryByDelayreset($value);


	public function deleteByBillid($value);

	public function deleteByProductid($value);

	public function deleteByType($value);

	public function deleteBySupplierid($value);

	public function deleteByAmount($value);

	public function deleteByRentprice($value);

	public function deleteBySupplierprice($value);

	public function deleteByTotalprice($value);

	public function deleteBySuppliertotalpice($value);

	public function deleteByStartdate($value);

	public function deleteByEnddate($value);

	public function deleteByRentdays($value);

	public function deleteByStatus($value);

	public function deleteByDelayvalue($value);

	public function deleteByDelaytype($value);

	public function deleteByDelypay($value);

	public function deleteByDelayreset($value);


}
?>