<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-01-21 13:45
 */
interface QuickprofitstoreDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Quickprofitstore 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param quickprofitstore primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Quickprofitstore quickprofitstore
 	 */
	public function insert($quickprofitstore);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Quickprofitstore quickprofitstore
 	 */
	public function update($quickprofitstore);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreId($value);

	public function queryByTheDate($value);

	public function queryBySellVal($value);

	public function queryBySellCostBuyPrice($value);

	public function queryBySellCostLastBuyPrice($value);

	public function queryBySellCostMeanBuyPrice($value);

	public function queryBySellCostLastBuyPricewithDiscount($value);

	public function queryBySellCostMeanBuyPricewithDiscount($value);

	public function queryByReturnSellVal($value);

	public function queryByReturnSellCostBuyPrice($value);

	public function queryByReturnSellCostLastBuyPrice($value);

	public function queryByReturnSellCostMeanBuyPrice($value);

	public function queryByReturnSellCostLastBuyPricewithDiscount($value);

	public function queryByReturnSellCostMeanBuyPricewithDiscount($value);


	public function deleteByStoreId($value);

	public function deleteByTheDate($value);

	public function deleteBySellVal($value);

	public function deleteBySellCostBuyPrice($value);

	public function deleteBySellCostLastBuyPrice($value);

	public function deleteBySellCostMeanBuyPrice($value);

	public function deleteBySellCostLastBuyPricewithDiscount($value);

	public function deleteBySellCostMeanBuyPricewithDiscount($value);

	public function deleteByReturnSellVal($value);

	public function deleteByReturnSellCostBuyPrice($value);

	public function deleteByReturnSellCostLastBuyPrice($value);

	public function deleteByReturnSellCostMeanBuyPrice($value);

	public function deleteByReturnSellCostLastBuyPricewithDiscount($value);

	public function deleteByReturnSellCostMeanBuyPricewithDiscount($value);


}
?>