<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MMaintenancereceiptDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MMaintenancereceipt 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mMaintenancereceipt primary key
 	 */
	public function delete($maintenanceReceiptId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MMaintenancereceipt mMaintenancereceipt
 	 */
	public function insert($mMaintenancereceipt);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MMaintenancereceipt mMaintenancereceipt
 	 */
	public function update($mMaintenancereceipt);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReceiptId($value);

	public function queryByTotalCost($value);

	public function queryByType($value);

	public function queryByUserId($value);

	public function queryByBranchId($value);

	public function queryByMaintenanceReceiptDAte($value);

	public function queryByDel($value);


	public function deleteByReceiptId($value);

	public function deleteByTotalCost($value);

	public function deleteByType($value);

	public function deleteByUserId($value);

	public function deleteByBranchId($value);

	public function deleteByMaintenanceReceiptDAte($value);

	public function deleteByDel($value);


}
?>