<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MComreceiptDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MComreceipt 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mComreceipt primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MComreceipt mComreceipt
 	 */
	public function insert($mComreceipt);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MComreceipt mComreceipt
 	 */
	public function update($mComreceipt);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReceiptserial($value);

	public function queryByReceiptdat($value);

	public function queryByBranchid($value);

	public function queryByClientid($value);

	public function queryByInitialcost($value);

	public function queryByUserid($value);

	public function queryByDel($value);

	public function queryByStatus($value);


	public function deleteByReceiptserial($value);

	public function deleteByReceiptdat($value);

	public function deleteByBranchid($value);

	public function deleteByClientid($value);

	public function deleteByInitialcost($value);

	public function deleteByUserid($value);

	public function deleteByDel($value);

	public function deleteByStatus($value);


}
?>