<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-12-08 17:01
 */
interface FaidadirectorDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Faidadirector 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param faidadirector primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Faidadirector faidadirector
 	 */
	public function insert($faidadirector);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Faidadirector faidadirector
 	 */
	public function update($faidadirector);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByFaidaId($value);

	public function queryByConditions($value);

	public function queryByComment($value);


	public function deleteByFaidaId($value);

	public function deleteByConditions($value);

	public function deleteByComment($value);


}
?>