<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-26 12:58
 */
interface EmployeeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employee 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employee primary key
 	 */
	public function delete($employeeId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employee employee
 	 */
	public function insert($employee);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employee employee
 	 */
	public function update($employee);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployeeName($value);

	public function queryByEmployeeBOD($value);

	public function queryByEmployeeAddress($value);

	public function queryByEmployeePhone($value);

	public function queryByEmployeeSalary($value);

	public function queryByEmployeeBouns($value);

	public function queryByEmployeeDate($value);

	public function queryByConditions($value);

	public function queryByUserId($value);

	public function queryByEmpdept($value);

	public function queryByIsworker($value);

	public function queryByHourlyrate($value);

	public function queryByHouseAllowance($value);

	public function queryByTransportationAllowance($value);

	public function queryByOtherAllowance($value);

	public function queryByNationality($value);

	public function queryByReligion($value);

	public function queryByNoOfWorkDaysPerMonth($value);

	public function queryByNoOfWorkHoursDaysPerDay($value);

	public function queryByNoOfDistountDaysWhenAbsences($value);

	public function queryByContract($value);

	public function queryByResidence($value);

	public function queryByPersonalPhoto($value);

	public function queryByHealthCard($value);

	public function queryByVisa($value);

	public function queryByPassport($value);

	public function queryByMinuteLateCost($value);

	public function queryByDayAbsencesCost($value);


	public function deleteByEmployeeName($value);

	public function deleteByEmployeeBOD($value);

	public function deleteByEmployeeAddress($value);

	public function deleteByEmployeePhone($value);

	public function deleteByEmployeeSalary($value);

	public function deleteByEmployeeBouns($value);

	public function deleteByEmployeeDate($value);

	public function deleteByConditions($value);

	public function deleteByUserId($value);

	public function deleteByEmpdept($value);

	public function deleteByIsworker($value);

	public function deleteByHourlyrate($value);

	public function deleteByHouseAllowance($value);

	public function deleteByTransportationAllowance($value);

	public function deleteByOtherAllowance($value);

	public function deleteByNationality($value);

	public function deleteByReligion($value);

	public function deleteByNoOfWorkDaysPerMonth($value);

	public function deleteByNoOfWorkHoursDaysPerDay($value);

	public function deleteByNoOfDistountDaysWhenAbsences($value);

	public function deleteByContract($value);

	public function deleteByResidence($value);

	public function deleteByPersonalPhoto($value);

	public function deleteByHealthCard($value);

	public function deleteByVisa($value);

	public function deleteByPassport($value);

	public function deleteByMinuteLateCost($value);

	public function deleteByDayAbsencesCost($value);


}
?>