<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-04-18 15:43
 */
interface DailyentrycreditorDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Dailyentrycreditor 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param dailyentrycreditor primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Dailyentrycreditor dailyentrycreditor
 	 */
	public function insert($dailyentrycreditor);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Dailyentrycreditor dailyentrycreditor
 	 */
	public function update($dailyentrycreditor);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDailyentryid($value);

	public function queryByAccountstreeid($value);

	public function queryByValue($value);

	public function queryByDComment($value);


	public function deleteByDailyentryid($value);

	public function deleteByAccountstreeid($value);

	public function deleteByValue($value);

	public function deleteByDComment($value);


}
?>