<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-13 14:36
 */
interface ClientpaymentreceipttDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Clientpaymentreceiptt 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param clientpaymentreceiptt primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Clientpaymentreceiptt clientpaymentreceiptt
 	 */
	public function insert($clientpaymentreceiptt);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Clientpaymentreceiptt clientpaymentreceiptt
 	 */
	public function update($clientpaymentreceiptt);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByBillid($value);

	public function queryByPayedtype($value);

	public function queryByPaymethod($value);

	public function queryByDebtbefore($value);

	public function queryByPayed($value);

	public function queryByDebtafter($value);


	public function deleteByClientid($value);

	public function deleteByBillid($value);

	public function deleteByPayedtype($value);

	public function deleteByPaymethod($value);

	public function deleteByDebtbefore($value);

	public function deleteByPayed($value);

	public function deleteByDebtafter($value);


}
?>