<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ClientdebtchangeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Clientdebtchange 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param clientdebtchange primary key
 	 */
	public function delete($clientdebtchangeid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Clientdebtchange clientdebtchange
 	 */
	public function insert($clientdebtchange);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Clientdebtchange clientdebtchange
 	 */
	public function update($clientdebtchange);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientdebtchangebefore($value);

	public function queryByClientdebtchangeamount($value);

	public function queryByClientdebtchangetype($value);

	public function queryByProcessname($value);

	public function queryByClientdebtchangemodelid($value);

	public function queryByClientdebtchangeafter($value);

	public function queryByClientdebtchangedate($value);

	public function queryByUserid($value);

	public function queryByTablename($value);


	public function deleteByClientdebtchangebefore($value);

	public function deleteByClientdebtchangeamount($value);

	public function deleteByClientdebtchangetype($value);

	public function deleteByProcessname($value);

	public function deleteByClientdebtchangemodelid($value);

	public function deleteByClientdebtchangeafter($value);

	public function deleteByClientdebtchangedate($value);

	public function deleteByUserid($value);

	public function deleteByTablename($value);


}
?>