<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface BankaccountDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Bankaccount 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param bankaccount primary key
 	 */
	public function delete($accountid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Bankaccount bankaccount
 	 */
	public function insert($bankaccount, $comment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Bankaccount bankaccount
 	 */
	public function update($bankaccount, $comment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByAccountname($value);

	public function queryByComment($value);

	public function queryByAccountnumber($value);

	public function queryByAccountbeginingbalance($value);

	public function queryByAccountdate($value);

	public function queryByAccountcurrencytype($value);

	public function queryByBankid($value);

	public function queryByUserid($value);

	public function queryByCondition($value);


	public function deleteByAccountname($value);

	public function deleteByComment($value);

	public function deleteByAccountnumber($value);

	public function deleteByAccountbeginingbalance($value);

	public function deleteByAccountdate($value);

	public function deleteByAccountcurrencytype($value);

	public function deleteByBankid($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);


}
?>