<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface AccountmovementDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Accountmovement 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param accountmovement primary key
 	 */
	public function delete($accountmovementid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Accountmovement accountmovement
 	 */
	public function insert($accountmovement);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Accountmovement accountmovement
 	 */
	public function update($accountmovement);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByAccountmovementbefore($value);

	public function queryByAccountmovementamount($value);

	public function queryByAccountmovementafter($value);

	public function queryByAccountmovementtype($value);

	public function queryByProcessname($value);

	public function queryByAccountmovementmodelid($value);

	public function queryByAccountmovementdate($value);

	public function queryByUserid($value);

	public function queryByAccountid($value);

	public function queryByTablename($value);

	public function queryByBankid($value);


	public function deleteByAccountmovementbefore($value);

	public function deleteByAccountmovementamount($value);

	public function deleteByAccountmovementafter($value);

	public function deleteByAccountmovementtype($value);

	public function deleteByProcessname($value);

	public function deleteByAccountmovementmodelid($value);

	public function deleteByAccountmovementdate($value);

	public function deleteByUserid($value);

	public function deleteByAccountid($value);

	public function deleteByTablename($value);

	public function deleteByBankid($value);


}
?>